/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import com.codahale.metrics.Counter;
import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.fcrepo.kernel.services.functions.GetClusterConfiguration;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.fcrepo.kernel.utils.FixityResult;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.fcrepo.kernel.utils.NamespaceTools;
import org.fcrepo.metrics.RegistryService;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrRdfTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrRdfTools.class);
    public static BiMap<String, String> jcrNamespacesToRDFNamespaces = ImmutableBiMap.of((Object)"http://www.jcp.org/jcr/1.0", (Object)"http://fedora.info/definitions/v4/repository#");
    public static BiMap<String, String> rdfNamespacesToJcrNamespaces = jcrNamespacesToRDFNamespaces.inverse();
    private static GetClusterConfiguration getClusterConfiguration = new GetClusterConfiguration();
    private static LowLevelStorageService llstore;
    private final GraphSubjects graphSubjects;
    private Session session;
    Predicate<NodeType> HAS_CHILD_NODE_DEFINITIONS = new Predicate<NodeType>(){

        public boolean apply(NodeType input) {
            return input.getChildNodeDefinitions().length > 0;
        }
    };

    public JcrRdfTools(GraphSubjects graphSubjects) {
        this.graphSubjects = graphSubjects;
    }

    public JcrRdfTools(GraphSubjects graphSubjects, Session session) {
        this.graphSubjects = graphSubjects;
        this.session = session;
    }

    public static JcrRdfTools withContext(GraphSubjects graphSubjects) {
        return new JcrRdfTools(graphSubjects);
    }

    public static JcrRdfTools withContext(GraphSubjects graphSubjects, Session session) {
        return new JcrRdfTools(graphSubjects, session);
    }

    public static String getJcrNamespaceForRDFNamespace(String rdfNamespaceUri) {
        if (rdfNamespacesToJcrNamespaces.containsKey((Object)rdfNamespaceUri)) {
            return (String)rdfNamespacesToJcrNamespaces.get((Object)rdfNamespaceUri);
        }
        return rdfNamespaceUri;
    }

    public static String getRDFNamespaceForJcrNamespace(String jcrNamespaceUri) {
        if (jcrNamespacesToRDFNamespaces.containsKey((Object)jcrNamespaceUri)) {
            return (String)jcrNamespacesToRDFNamespaces.get((Object)jcrNamespaceUri);
        }
        return jcrNamespaceUri;
    }

    public static Model getProblemsModel() {
        return ModelFactory.createDefaultModel();
    }

    public JcrRdfTools withSession(Session session) {
        return new JcrRdfTools(this.graphSubjects, session);
    }

    public Model getJcrPropertiesModel() throws RepositoryException {
        Model model = ModelFactory.createDefaultModel();
        NamespaceRegistry namespaceRegistry = NamespaceTools.getNamespaceRegistry(this.session);
        assert (namespaceRegistry != null);
        for (String prefix : namespaceRegistry.getPrefixes()) {
            String nsURI = namespaceRegistry.getURI(prefix);
            if (nsURI == null || nsURI.equals("") || prefix.equals("xmlns")) continue;
            if (prefix.equals("jcr")) {
                model.setNsPrefix("fcrepo", JcrRdfTools.getRDFNamespaceForJcrNamespace(nsURI));
                continue;
            }
            model.setNsPrefix(prefix, JcrRdfTools.getRDFNamespaceForJcrNamespace(nsURI));
        }
        return model;
    }

    public Model getJcrPropertiesModel(Iterator<Node> nodeIterator, Resource iteratorSubject) throws RepositoryException {
        if (!nodeIterator.hasNext()) {
            return ModelFactory.createDefaultModel();
        }
        PeekingIterator iterator = Iterators.peekingIterator(nodeIterator);
        Model model = this.getJcrPropertiesModel();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            this.addJcrPropertiesToModel(node, model);
            if (iteratorSubject == null) continue;
            model.add(iteratorSubject, RdfLexicon.HAS_MEMBER_OF_RESULT, (RDFNode)this.graphSubjects.getGraphSubject(node));
        }
        return model;
    }

    public Model getJcrPropertiesModel(Node node) throws RepositoryException {
        Model model = this.getJcrPropertiesModel();
        if (node.getPrimaryNodeType().getName().equals("mode:root")) {
            LOGGER.debug("Creating RDF response for repository description");
            this.addRepositoryMetricsToModel(node, model);
        }
        this.addJcrPropertiesToModel(node, model);
        return model;
    }

    public Model getJcrPropertiesModel(VersionHistory versionHistory, Resource subject) throws RepositoryException {
        Model model = this.getJcrPropertiesModel();
        VersionIterator versionIterator = versionHistory.getAllVersions();
        while (versionIterator.hasNext()) {
            String[] versionLabels;
            Version version = versionIterator.nextVersion();
            Node frozenNode = version.getFrozenNode();
            Resource versionSubject = this.graphSubjects.getGraphSubject(frozenNode);
            model.add(subject, RdfLexicon.HAS_VERSION, (RDFNode)versionSubject);
            for (String label : versionLabels = versionHistory.getVersionLabels(version)) {
                model.add(versionSubject, RdfLexicon.HAS_VERSION_LABEL, label);
            }
            PropertyIterator properties = frozenNode.getProperties();
            while (properties.hasNext()) {
                Property property = properties.nextProperty();
                this.addPropertyToModel(versionSubject, model, property);
            }
        }
        return model;
    }

    public Model getJcrPropertiesModel(Node node, Iterable<FixityResult> blobs) throws RepositoryException {
        Model model = this.getJcrPropertiesModel();
        this.addJcrPropertiesToModel(node, model);
        for (FixityResult result : blobs) {
            Resource resultSubject = ResourceFactory.createResource();
            model.add(resultSubject, RdfLexicon.IS_FIXITY_RESULT_OF, (RDFNode)this.graphSubjects.getGraphSubject(node));
            model.add(this.graphSubjects.getGraphSubject(node), RdfLexicon.HAS_FIXITY_RESULT, (RDFNode)resultSubject);
            model.add(resultSubject, RdfLexicon.HAS_LOCATION, (RDFNode)ResourceFactory.createResource((String)result.getStoreIdentifier()));
            for (FixityResult.FixityState state : result.status) {
                model.add(resultSubject, RdfLexicon.HAS_FIXITY_STATE, (RDFNode)ResourceFactory.createTypedLiteral((Object)state.toString()));
            }
            String checksum = result.computedChecksum.toString();
            model.add(resultSubject, RdfLexicon.HAS_COMPUTED_CHECKSUM, (RDFNode)ResourceFactory.createResource((String)checksum));
            model.add(resultSubject, RdfLexicon.HAS_COMPUTED_SIZE, (RDFNode)ResourceFactory.createTypedLiteral((Object)result.computedSize));
        }
        return model;
    }

    public Model getJcrNamespaceModel() throws RepositoryException {
        Model model = this.getJcrPropertiesModel();
        Map prefixMap = model.getNsPrefixMap();
        for (Map.Entry entry : prefixMap.entrySet()) {
            if (((String)entry.getKey()).isEmpty()) continue;
            Resource nsSubject = ResourceFactory.createResource((String)((String)entry.getValue()));
            model.add(nsSubject, RDF.type, (RDFNode)RdfLexicon.VOAF_VOCABULARY);
            model.add(nsSubject, RdfLexicon.HAS_NAMESPACE_PREFIX, (RDFNode)ResourceFactory.createPlainLiteral((String)((String)entry.getKey())));
            model.add(nsSubject, RdfLexicon.HAS_NAMESPACE_URI, (RDFNode)ResourceFactory.createPlainLiteral((String)((String)entry.getValue())));
        }
        return model;
    }

    public Model getJcrTreeModel(Node node, long offset, int limit) throws RepositoryException {
        Model model = this.getJcrPropertiesModel();
        if (limit < -1) {
            return model;
        }
        Resource subject = this.graphSubjects.getGraphSubject(node);
        Resource pageContext = this.graphSubjects.getContext();
        model.add(pageContext, RDF.type, (RDFNode)model.createResource("http://www.w3.org/ns/ldp#Page"));
        model.add(pageContext, RdfLexicon.PAGE_OF, (RDFNode)subject);
        if (this.isContainer(node)) {
            model.add(pageContext, model.createProperty("http://www.w3.org/ns/ldp#membersInlined"), (RDFNode)model.createTypedLiteral(true));
            model.add(subject, RDF.type, (RDFNode)model.createResource("http://www.w3.org/ns/ldp#Container"));
            model.add(subject, model.createProperty("http://www.w3.org/ns/ldp#membershipSubject"), (RDFNode)subject);
            model.add(subject, model.createProperty("http://www.w3.org/ns/ldp#membershipPredicate"), (RDFNode)RdfLexicon.HAS_CHILD);
            model.add(subject, model.createProperty("http://www.w3.org/ns/ldp#membershipObject"), (RDFNode)model.createResource("http://www.w3.org/ns/ldp#MemberSubject"));
        }
        if (node.getDepth() > 0) {
            Node parentNode = node.getParent();
            Resource parentNodeSubject = this.graphSubjects.getGraphSubject(parentNode);
            model.add(subject, RdfLexicon.HAS_PARENT, (RDFNode)parentNodeSubject);
            model.add(parentNodeSubject, RdfLexicon.HAS_CHILD, (RDFNode)subject);
            this.addJcrPropertiesToModel(parentNode, model);
            model.add(pageContext, model.createProperty("http://www.w3.org/ns/ldp#inlinedResource"), (RDFNode)parentNodeSubject);
        }
        if (node.hasNodes()) {
            if (limit == -1) {
                model.add(pageContext, RdfLexicon.PAGE, (RDFNode)RDF.nil);
            }
            NodeIterator nodeIterator = node.getNodes();
            int i = 0;
            long excludedNodeCount = 0L;
            while (nodeIterator.hasNext()) {
                Node childNode = nodeIterator.nextNode();
                if (FedoraTypesUtils.isInternalNode.apply((Object)childNode) || childNode.getName().equals("jcr:content")) {
                    ++excludedNodeCount;
                    continue;
                }
                Resource childNodeSubject = this.graphSubjects.getGraphSubject(childNode);
                if ((long)i >= offset && (limit == -1 || (long)i < offset + (long)limit)) {
                    this.addJcrPropertiesToModel(childNode, model);
                    model.add(pageContext, model.createProperty("http://www.w3.org/ns/ldp#inlinedResource"), (RDFNode)childNodeSubject);
                    model.add(childNodeSubject, RdfLexicon.HAS_PARENT, (RDFNode)subject);
                }
                ++i;
                model.add(subject, RdfLexicon.HAS_CHILD, (RDFNode)childNodeSubject);
            }
            model.add(subject, RdfLexicon.HAS_CHILD_COUNT, (RDFNode)ResourceFactory.createTypedLiteral((Object)(nodeIterator.getSize() - excludedNodeCount)));
        }
        return model;
    }

    private boolean isContainer(Node node) throws RepositoryException {
        return this.HAS_CHILD_NODE_DEFINITIONS.apply((Object)node.getPrimaryNodeType()) || Iterables.any((Iterable)ImmutableList.copyOf((Object[])node.getMixinNodeTypes()), this.HAS_CHILD_NODE_DEFINITIONS);
    }

    public boolean isInternalProperty(Node subjectNode, Resource predicate) {
        switch (predicate.getNameSpace()) {
            case "http://fedora.info/definitions/v4/repository#": 
            case "http://www.jcp.org/jcr/1.0": 
            case "http://www.w3.org/ns/ldp#": {
                return true;
            }
        }
        return false;
    }

    private void addJcrPropertiesToModel(Node node, Model model) throws RepositoryException {
        Resource subject = this.graphSubjects.getGraphSubject(node);
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            this.addPropertyToModel(subject, model, property);
        }
        if (node.hasNode("jcr:content")) {
            Node contentNode = node.getNode("jcr:content");
            Resource contentSubject = this.graphSubjects.getGraphSubject(contentNode);
            model.add(subject, RdfLexicon.HAS_CONTENT, (RDFNode)contentSubject);
            model.add(contentSubject, RdfLexicon.IS_CONTENT_OF, (RDFNode)subject);
            this.addJcrPropertiesToModel(contentNode, model);
            this.addJcrContentLocationInformationToModel(node, model);
        }
    }

    private void addRepositoryMetricsToModel(Node node, Model model) throws RepositoryException {
        Repository repository = node.getSession().getRepository();
        SortedMap counters = RegistryService.getMetrics().getCounters();
        Resource subject = this.graphSubjects.getGraphSubject(node);
        for (String key : repository.getDescriptorKeys()) {
            String descriptor = repository.getDescriptor(key);
            if (descriptor == null) continue;
            String uri = "http://fedora.info/definitions/v4/repository#repository/" + key;
            model.add(subject, model.createProperty(uri), descriptor);
        }
        NodeTypeManager nodeTypeManager = FedoraTypesUtils.getNodeTypeManager(node);
        NodeTypeIterator nodeTypes = nodeTypeManager.getAllNodeTypes();
        while (nodeTypes.hasNext()) {
            NodeType nodeType = nodeTypes.nextNodeType();
            model.add(subject, RdfLexicon.HAS_NODE_TYPE, nodeType.getName());
        }
        model.add(subject, RdfLexicon.HAS_OBJECT_COUNT, (RDFNode)ResourceFactory.createTypedLiteral((Object)FedoraTypesUtils.getRepositoryCount(repository)));
        model.add(subject, RdfLexicon.HAS_OBJECT_SIZE, (RDFNode)ResourceFactory.createTypedLiteral((Object)FedoraTypesUtils.getRepositorySize(repository)));
        Map<String, String> config = getClusterConfiguration.apply(repository);
        assert (config != null);
        for (Map.Entry<String, String> entry : config.entrySet()) {
            model.add(subject, model.createProperty("http://fedora.info/definitions/v4/repository#" + entry.getKey()), entry.getValue());
        }
        if (counters.containsKey("LowLevelStorageService.fixity-check-counter")) {
            model.add(subject, RdfLexicon.HAS_FIXITY_CHECK_COUNT, (RDFNode)ResourceFactory.createTypedLiteral((Object)((Counter)counters.get("org.fcrepo.services.LowLevelStorageService.fixity-check-counter")).getCount()));
        }
        if (counters.containsKey("LowLevelStorageService.fixity-error-counter")) {
            model.add(subject, RdfLexicon.HAS_FIXITY_ERROR_COUNT, (RDFNode)ResourceFactory.createTypedLiteral((Object)((Counter)counters.get("org.fcrepo.services.LowLevelStorageService.fixity-error-counter")).getCount()));
        }
        if (counters.containsKey("LowLevelStorageService.fixity-repaired-counter")) {
            model.add(subject, RdfLexicon.HAS_FIXITY_REPAIRED_COUNT, (RDFNode)ResourceFactory.createTypedLiteral((Object)((Counter)counters.get("org.fcrepo.services.LowLevelStorageService.fixity-repaired-counter")).getCount()));
        }
    }

    private void addJcrContentLocationInformationToModel(Node node, Model model) throws RepositoryException {
        Node contentNode = node.getNode("jcr:content");
        Resource contentNodeSubject = this.graphSubjects.getGraphSubject(contentNode);
        if (llstore == null) {
            llstore = new LowLevelStorageService();
            llstore.setRepository(node.getSession().getRepository());
        }
        Set<LowLevelCacheEntry> cacheEntries = llstore.getLowLevelCacheEntries(contentNode);
        for (LowLevelCacheEntry e : cacheEntries) {
            model.add(contentNodeSubject, RdfLexicon.HAS_LOCATION, e.getExternalIdentifier());
        }
    }

    Value createValue(Node node, RDFNode data, int type) throws RepositoryException {
        ValueFactory valueFactory = (ValueFactory)FedoraTypesUtils.getValueFactory.apply((Object)node);
        assert (valueFactory != null);
        if (data.isURIResource() && (type == 9 || type == 10)) {
            Node nodeFromGraphSubject = this.graphSubjects.getNodeFromGraphSubject(data.asResource());
            return valueFactory.createValue(nodeFromGraphSubject, type == 10);
        }
        if (data.isURIResource() || type == 11) {
            return valueFactory.createValue(data.toString(), 11);
        }
        if (data.isResource()) {
            return valueFactory.createValue(data.toString(), 0);
        }
        if (data.isLiteral() && type == 0) {
            Literal literal = data.asLiteral();
            RDFDatatype dataType = literal.getDatatype();
            Object rdfValue = literal.getValue();
            if (rdfValue instanceof Boolean) {
                return valueFactory.createValue(((Boolean)rdfValue).booleanValue());
            }
            if (rdfValue instanceof Byte || dataType != null && dataType.getJavaClass() == Byte.class) {
                return valueFactory.createValue((long)literal.getByte());
            }
            if (rdfValue instanceof Double) {
                return valueFactory.createValue(((Double)rdfValue).doubleValue());
            }
            if (rdfValue instanceof Float) {
                return valueFactory.createValue((double)((Float)rdfValue).floatValue());
            }
            if (rdfValue instanceof Long || dataType != null && dataType.getJavaClass() == Long.class) {
                return valueFactory.createValue(literal.getLong());
            }
            if (rdfValue instanceof Short || dataType != null && dataType.getJavaClass() == Short.class) {
                return valueFactory.createValue((long)literal.getShort());
            }
            if (rdfValue instanceof Integer) {
                return valueFactory.createValue((long)((Integer)rdfValue).intValue());
            }
            if (rdfValue instanceof XSDDateTime) {
                return valueFactory.createValue(((XSDDateTime)rdfValue).asCalendar());
            }
            return valueFactory.createValue(literal.getString(), 1);
        }
        return valueFactory.createValue(data.asLiteral().getString(), type);
    }

    void addPropertyToModel(Resource subject, Model model, Property property) throws RepositoryException {
        if (property.isMultiple()) {
            Value[] values;
            for (Value v : values = property.getValues()) {
                this.addPropertyToModel(subject, model, property, v);
            }
        } else {
            this.addPropertyToModel(subject, model, property, property.getValue());
        }
    }

    void addPropertyToModel(Resource subject, Model model, Property property, Value v) throws RepositoryException {
        if (v.getType() == 2) {
            return;
        }
        com.hp.hpl.jena.rdf.model.Property predicate = (com.hp.hpl.jena.rdf.model.Property)FedoraTypesUtils.getPredicateForProperty.apply((Object)property);
        switch (v.getType()) {
            case 6: {
                model.addLiteral(subject, predicate, v.getBoolean());
                break;
            }
            case 5: {
                model.add(subject, predicate, (RDFNode)ResourceFactory.createTypedLiteral((Object)v.getDate()));
                break;
            }
            case 12: {
                model.add(subject, predicate, (RDFNode)ResourceFactory.createTypedLiteral((Object)v.getDecimal()));
                break;
            }
            case 4: {
                model.addLiteral(subject, predicate, v.getDouble());
                break;
            }
            case 3: {
                model.addLiteral(subject, predicate, v.getLong());
                break;
            }
            case 11: {
                model.add(subject, predicate, (RDFNode)model.createResource(v.getString()));
                return;
            }
            case 9: 
            case 10: {
                Node refNode = this.session.getNodeByIdentifier(v.getString());
                model.add(subject, predicate, (RDFNode)this.graphSubjects.getGraphSubject(refNode));
                break;
            }
            case 8: {
                model.add(subject, predicate, (RDFNode)this.graphSubjects.getGraphSubject(v.getString()));
                break;
            }
            default: {
                model.add(subject, predicate, v.getString());
            }
        }
    }

    String getPropertyNameFromPredicate(Node node, com.hp.hpl.jena.rdf.model.Property predicate) throws RepositoryException {
        Map<String, String> s = Collections.emptyMap();
        return this.getPropertyNameFromPredicate(node, predicate, s);
    }

    String getPropertyNameFromPredicate(Node node, com.hp.hpl.jena.rdf.model.Property predicate, Map<String, String> namespaceMapping) throws RepositoryException {
        String prefix;
        String namespace = JcrRdfTools.getJcrNamespaceForRDFNamespace(predicate.getNameSpace());
        NamespaceRegistry namespaceRegistry = NamespaceTools.getNamespaceRegistry((Item)node);
        assert (namespaceRegistry != null);
        if (namespaceRegistry.isRegisteredUri(namespace)) {
            prefix = namespaceRegistry.getPrefix(namespace);
        } else {
            ImmutableBiMap nsMap = ImmutableBiMap.copyOf(namespaceMapping);
            if (nsMap.containsValue((Object)namespace) && !namespaceRegistry.isRegisteredPrefix((String)nsMap.inverse().get((Object)namespace))) {
                prefix = (String)nsMap.inverse().get((Object)namespace);
                namespaceRegistry.registerNamespace(prefix, namespace);
            } else {
                prefix = namespaceRegistry.registerNamespace(namespace);
            }
        }
        String localName = predicate.getLocalName();
        String propertyName = prefix + ":" + localName;
        LOGGER.trace("Took RDF predicate {} and translated it to JCR property {}", (Object)predicate, (Object)propertyName);
        return propertyName;
    }

    public static void setGetClusterConfiguration(GetClusterConfiguration newClusterConfiguration) {
        getClusterConfiguration = newClusterConfiguration;
    }

    public static void setLlstore(LowLevelStorageService lowLevelStorageService) {
        llstore = lowLevelStorageService;
    }
}

