/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.fcrepo.kernel.utils.ContentDigest;
import org.fcrepo.kernel.utils.FixityInputStream;
import org.fcrepo.kernel.utils.FixityResult;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LowLevelCacheEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LowLevelCacheEntry.class);
    protected static final String DATA_SUFFIX = "-data";
    protected String externalId;
    protected final BinaryKey key;

    protected LowLevelCacheEntry(BinaryKey key) {
        this.key = key;
        this.externalId = "";
    }

    public abstract InputStream getInputStream() throws BinaryStoreException;

    public abstract void storeValue(InputStream var1) throws BinaryStoreException, IOException;

    public abstract String getExternalIdentifier();

    public FixityResult checkFixity(URI checksum, long size) throws BinaryStoreException {
        FixityInputStream ds;
        String digest = ContentDigest.getAlgorithm(checksum);
        try {
            ds = new FixityInputStream(this.getInputStream(), MessageDigest.getInstance(digest));
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.warn("Could not create MessageDigest: {}", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        try {
            while (ds.read() != -1) {
            }
            FixityResult result = new FixityResult(this, ds.getByteCount(), ContentDigest.asURI(digest, ds.getMessageDigest().digest()));
            if (!result.matches(checksum)) {
                result.status.add(FixityResult.FixityState.BAD_CHECKSUM);
            }
            if (!result.matches(size)) {
                result.status.add(FixityResult.FixityState.BAD_SIZE);
            }
            if (result.matches(size, checksum)) {
                result.status.add(FixityResult.FixityState.SUCCESS);
            }
            LOGGER.debug("Got {}", (Object)result.toString());
            FixityResult fixityResult = result;
            return fixityResult;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            try {
                ds.close();
            }
            catch (IOException e) {
                LOGGER.debug("Got error closing input stream: {}", (Throwable)e);
            }
        }
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public BinaryKey getKey() {
        return this.key;
    }
}

