/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.modeshape.jcr.api.NamespaceRegistry;

public abstract class NamespaceTools {
    public static Function<Node, NamespaceRegistry> getNamespaceRegistry = new Function<Node, NamespaceRegistry>(){

        public NamespaceRegistry apply(Node n) {
            try {
                Preconditions.checkArgument((n != null ? 1 : 0) != 0, (Object)"null has no Namespace Registry associated with it!");
                return (NamespaceRegistry)n.getSession().getWorkspace().getNamespaceRegistry();
            }
            catch (RepositoryException e) {
                throw new IllegalStateException(e);
            }
        }
    };

    public static NamespaceRegistry getNamespaceRegistry(Session session) throws RepositoryException {
        return (NamespaceRegistry)session.getWorkspace().getNamespaceRegistry();
    }

    public static NamespaceRegistry getNamespaceRegistry(Item item) throws RepositoryException {
        return NamespaceTools.getNamespaceRegistry(item.getSession());
    }
}

