/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import java.util.ArrayList;
import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodePropertiesTools {
    private static final Logger logger = LoggerFactory.getLogger(NodePropertiesTools.class);

    public static void appendOrReplaceNodeProperty(Node node, String propertyName, Value newValue) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            Property property = node.getProperty(propertyName);
            if (property.isMultiple()) {
                logger.debug("Appending value {} to {} property {}", new Object[]{newValue, PropertyType.nameFromValue((int)property.getType()), propertyName});
                ArrayList<Value> newValues = new ArrayList<Value>();
                Collections.addAll(newValues, node.getProperty(propertyName).getValues());
                if (!newValues.contains(newValue)) {
                    newValues.add(newValue);
                    property.setValue(newValues.toArray(new Value[newValues.size()]));
                }
            } else {
                logger.debug("Overwriting {} property {} with new value {}", new Object[]{PropertyType.nameFromValue((int)property.getType()), propertyName, newValue});
                property.setValue(newValue);
            }
        } else if (NodePropertiesTools.isMultivaluedProperty(node, propertyName)) {
            logger.debug("Creating new multivalued {} property {} with initial value [{}]", new Object[]{PropertyType.nameFromValue((int)newValue.getType()), propertyName, newValue});
            node.setProperty(propertyName, new Value[]{newValue}, newValue.getType());
        } else {
            logger.debug("Creating new single-valued {} property {} with initial value {}", new Object[]{PropertyType.nameFromValue((int)newValue.getType()), propertyName, newValue});
            node.setProperty(propertyName, newValue, newValue.getType());
        }
    }

    public static void removeNodeProperty(Node node, String propertyName, Value valueToRemove) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            Property property = node.getProperty(propertyName);
            if (FedoraTypesUtils.isMultipleValuedProperty.apply((Object)property)) {
                ArrayList<Value> newValues = new ArrayList<Value>();
                boolean remove = false;
                for (Value v : node.getProperty(propertyName).getValues()) {
                    if (v.equals(valueToRemove)) {
                        remove = true;
                        continue;
                    }
                    newValues.add(v);
                }
                if (remove) {
                    if (newValues.size() == 0) {
                        logger.debug("Removing property {}", (Object)propertyName);
                        property.setValue((Value[])null);
                    } else {
                        logger.debug("Removing value {} from property {}", (Object)valueToRemove, (Object)propertyName);
                        property.setValue(newValues.toArray(new Value[newValues.size()]));
                    }
                }
            } else if (property.getValue().equals(valueToRemove)) {
                logger.debug("Removing value {} property {}", (Object)propertyName);
                property.setValue((Value)null);
            }
        }
    }

    public static int getPropertyType(Node node, String propertyName) throws RepositoryException {
        PropertyDefinition def = FedoraTypesUtils.getDefinitionForPropertyName(node, propertyName);
        if (def == null) {
            return 0;
        }
        return def.getRequiredType();
    }

    public static boolean isMultivaluedProperty(Node node, String propertyName) throws RepositoryException {
        PropertyDefinition def = FedoraTypesUtils.getDefinitionForPropertyName(node, propertyName);
        if (def == null) {
            return true;
        }
        return def.isMultiple();
    }
}

