/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Properties;
import org.apache.poi.util.IOUtils;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.fcrepo.kernel.utils.infinispan.StoreChunkInputStream;
import org.fcrepo.kernel.utils.infinispan.StoreChunkOutputStream;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.file.FileCacheStoreConfig;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheStoreEntry
extends LowLevelCacheEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheStoreEntry.class);
    private final CacheStore store;
    private final String cacheName;

    public CacheStoreEntry(CacheStore store, String cacheName, BinaryKey key) {
        super(key);
        this.store = store;
        this.cacheName = cacheName;
    }

    public CacheStore getLowLevelStore() {
        return this.store;
    }

    @Override
    public InputStream getInputStream() throws BinaryStoreException {
        return new StoreChunkInputStream(this.store, this.key.toString() + "-data");
    }

    @Override
    public void storeValue(InputStream stream) throws BinaryStoreException, IOException {
        LOGGER.info("Doing a low-level write to store {} for key {}", (Object)this.getExternalIdentifier(), (Object)this.key);
        StoreChunkOutputStream outputStream = new StoreChunkOutputStream(this.store, this.key.toString() + "-data");
        IOUtils.copy((InputStream)stream, (OutputStream)outputStream);
        ((OutputStream)outputStream).close();
    }

    @Override
    public String getExternalIdentifier() {
        CacheStoreConfig config = this.store.getCacheStoreConfig();
        String ispnExternalId = null;
        if (config instanceof AbstractCacheStoreConfig && (ispnExternalId = CacheStoreEntry.getStoreIdentifier((AbstractCacheStoreConfig)config)) != null) {
            return ispnExternalId;
        }
        if (config instanceof FileCacheStoreConfig) {
            ispnExternalId = CacheStoreEntry.getStoreIdentifier((FileCacheStoreConfig)config);
        }
        if (config == null) {
            return this.getExternalId() + "/" + this.store.getClass().getName() + ":" + this.cacheName + ":" + AbstractCacheStoreConfig.class.getPackage() + "ChainingCacheStoreConfig:" + ispnExternalId;
        }
        if (ispnExternalId == null) {
            ispnExternalId = config.toString();
        }
        return this.getExternalId() + "/" + this.store.getClass().getName() + ":" + this.cacheName + ":" + config.getCacheLoaderClassName() + ":" + ispnExternalId;
    }

    private static String getStoreIdentifier(AbstractCacheStoreConfig config) {
        Properties properties = config.getProperties();
        if (properties.containsKey("id")) {
            return properties.getProperty("id");
        }
        return null;
    }

    private static String getStoreIdentifier(FileCacheStoreConfig config) {
        return config.getLocation();
    }

    public boolean equals(Object other) {
        if (other instanceof CacheStoreEntry) {
            CacheStoreEntry that = (CacheStoreEntry)other;
            return this.key.equals((Object)that.getKey()) && this.cacheName.equals(that.cacheName) && (this.store == null && that.store == null || this.store != null && this.store.equals(that.store));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.store, this.key);
    }
}

