/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.fcrepo.kernel.utils.impl.CacheStoreEntry;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.configuration.cache.FileCacheStoreConfiguration;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStoreException;

public class ChainingCacheStoreEntry
extends LowLevelCacheEntry {
    private final ChainingCacheStore store;
    private final String cacheName;

    public ChainingCacheStoreEntry(ChainingCacheStore store, String cacheName, BinaryKey key) {
        super(key);
        this.store = store;
        this.cacheName = cacheName;
    }

    @Override
    public InputStream getInputStream() throws BinaryStoreException {
        throw new UnsupportedOperationException("getInputStream must be called on chained entries");
    }

    @Override
    public void storeValue(InputStream stream) throws BinaryStoreException, IOException {
        throw new UnsupportedOperationException("storeValue must be called on chained entries");
    }

    @Override
    public String getExternalIdentifier() {
        return null;
    }

    public Set<LowLevelCacheEntry> chainedEntries() {
        Set stores = this.store.getStores().keySet();
        HashSet<LowLevelCacheEntry> result = new HashSet<LowLevelCacheEntry>(stores.size());
        for (CacheStore store : stores) {
            Object name;
            String cacheName = null;
            CacheStoreConfiguration config = (CacheStoreConfiguration)this.store.getStores().get(store);
            if (config instanceof FileCacheStoreConfiguration) {
                cacheName = ((FileCacheStoreConfiguration)config).location();
            }
            if (config instanceof AbstractStoreConfiguration && cacheName == null && (name = ((AbstractStoreConfiguration)config).properties().get((Object)"id")) != null) {
                cacheName = name.toString();
            }
            if (cacheName == null) {
                cacheName = this.cacheName;
            }
            result.add(new CacheStoreEntry(store, cacheName, this.key));
        }
        return result;
    }
}

