/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.FileSystemBinaryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBinaryStoreEntry
extends LowLevelCacheEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalBinaryStoreEntry.class);
    private final BinaryStore store;

    public LocalBinaryStoreEntry(BinaryStore store, BinaryKey key) {
        super(key);
        this.store = store;
    }

    BinaryStore getStore() {
        return this.store;
    }

    @Override
    public InputStream getInputStream() throws BinaryStoreException {
        return this.store.getInputStream(this.key);
    }

    @Override
    public void storeValue(InputStream stream) throws BinaryStoreException, IOException {
        LOGGER.info("Doing a low-level write to store {} for key {}", (Object)this.getExternalIdentifier(), (Object)this.key);
        this.store.storeValue(stream);
    }

    @Override
    public String getExternalIdentifier() {
        if (this.store instanceof FileSystemBinaryStore) {
            FileSystemBinaryStore fsStore = (FileSystemBinaryStore)this.store;
            return this.getExternalId() + "/" + this.store.getClass().getName() + ":" + fsStore.getDirectory().toPath();
        }
        return this.getExternalId() + "/" + this.store.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof LocalBinaryStoreEntry) {
            LocalBinaryStoreEntry that = (LocalBinaryStoreEntry)other;
            return this.key.equals((Object)that.getKey()) && (this.store == null && that.store == null || this.store != null && this.store.equals(that.store));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.store, this.key);
    }
}

