/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils.infinispan;

import java.io.IOException;
import java.io.InputStream;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.modeshape.common.logging.Logger;

public class StoreChunkInputStream
extends InputStream {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final CacheStore blobCache;
    private final String key;
    protected int indexInBuffer;
    protected byte[] buffer;
    private int chunkNumber;

    public StoreChunkInputStream(CacheStore blobCache, String key) {
        this.blobCache = blobCache;
        this.key = key;
    }

    @Override
    public int read() throws IOException {
        if (this.indexInBuffer == -1) {
            return -1;
        }
        if (this.buffer == null || this.indexInBuffer >= this.buffer.length) {
            this.fillBuffer();
            return this.read();
        }
        return this.buffer[this.indexInBuffer++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.indexInBuffer == -1) {
            return -1;
        }
        if (this.buffer == null) {
            this.fillBuffer();
            return this.read(b, off, len);
        }
        if (this.indexInBuffer >= this.buffer.length) {
            return -1;
        }
        if (this.indexInBuffer + len > this.buffer.length) {
            len = this.buffer.length - this.indexInBuffer;
        }
        System.arraycopy(this.buffer, this.indexInBuffer, b, off, len);
        this.indexInBuffer += len;
        if (this.indexInBuffer == this.buffer.length) {
            this.buffer = null;
            this.indexInBuffer = 0;
        }
        return len;
    }

    @Override
    public int available() throws IOException {
        if (this.buffer == null) {
            return 0;
        }
        if (this.indexInBuffer >= 0) {
            return this.buffer.length - this.indexInBuffer;
        }
        return -1;
    }

    @Override
    public final long skip(long n) throws IOException {
        if (n <= 0L || this.indexInBuffer == -1) {
            return 0L;
        }
        if (this.buffer == null) {
            this.fillBuffer();
            return this.skip(n);
        }
        if ((long)this.indexInBuffer + n >= (long)this.buffer.length) {
            long skipped = this.buffer.length - this.indexInBuffer;
            this.buffer = null;
            this.indexInBuffer = 0;
            return skipped;
        }
        this.indexInBuffer = (int)((long)this.indexInBuffer + n);
        return n;
    }

    private void fillBuffer() throws IOException {
        this.buffer = this.nextChunk();
        if (this.buffer == null) {
            this.buffer = new byte[0];
            this.indexInBuffer = -1;
        } else {
            this.indexInBuffer = 0;
        }
    }

    protected byte[] nextChunk() throws IOException {
        String chunkKey = this.key + "-" + this.chunkNumber++;
        this.logger.debug("Read chunk {0} from cache {1}", new Object[]{chunkKey, this.blobCache});
        try {
            InternalCacheEntry cacheEntry = this.blobCache.load((Object)chunkKey);
            if (cacheEntry == null) {
                this.logger.trace("Unable to read chunk {0}", new Object[]{chunkKey});
                return null;
            }
            return (byte[])cacheEntry.getValue();
        }
        catch (CacheLoaderException e) {
            throw new IOException(e);
        }
    }
}

