/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils.infinispan;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.InternalEntryFactoryImpl;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.metadata.EmbeddedMetadata;
import org.modeshape.common.logging.Logger;

public class StoreChunkOutputStream
extends OutputStream {
    protected final Logger logger;
    public static final int CHUNKSIZE = 0x100000;
    private static final int CHUNK_BUFFER_SIZE = 1024;
    protected final CacheStore blobCache;
    protected final String keyPrefix;
    private final ByteArrayOutputStream chunkBuffer;
    private boolean closed;
    protected int chunkIndex;
    private final InternalEntryFactory entryFactory = new InternalEntryFactoryImpl();

    public StoreChunkOutputStream(CacheStore blobCache, String keyPrefix) {
        this.logger = Logger.getLogger(this.getClass());
        this.blobCache = blobCache;
        this.keyPrefix = keyPrefix;
        this.chunkBuffer = new ByteArrayOutputStream(1024);
    }

    public int getNumberChunks() {
        return this.chunkIndex;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.chunkBuffer.size() == 0x100000) {
            this.storeBufferInBLOBCache();
        }
        this.chunkBuffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len + this.chunkBuffer.size() <= 0x100000) {
            this.chunkBuffer.write(b, off, len);
        } else {
            int storeLength = 0x100000 - this.chunkBuffer.size();
            this.write(b, off, storeLength);
            this.storeBufferInBLOBCache();
            this.write(b, off + storeLength, len - storeLength);
        }
    }

    @Override
    public void close() throws IOException {
        this.logger.debug("Close. Buffer size at close: {0}", new Object[]{this.chunkBuffer.size()});
        if (this.closed) {
            this.logger.debug("Stream already closed.", new Object[0]);
            return;
        }
        this.closed = true;
        if (this.chunkBuffer.size() > 0) {
            this.storeBufferInBLOBCache();
        }
    }

    private void storeBufferInBLOBCache() throws IOException {
        byte[] chunk = this.chunkBuffer.toByteArray();
        try {
            String chunkKey = this.keyPrefix + "-" + this.chunkIndex;
            InternalCacheEntry c = this.blobCache.load((Object)chunkKey);
            InternalCacheEntry cacheEntry = c == null ? this.entryFactory.create((Object)chunkKey, (Object)chunk, new EmbeddedMetadata.Builder().build()) : this.entryFactory.create((Object)chunkKey, (Object)chunk, c);
            this.logger.debug("Store chunk {0}", new Object[]{chunkKey});
            this.blobCache.store(cacheEntry);
            ++this.chunkIndex;
            this.chunkBuffer.reset();
        }
        catch (CacheLoaderException e) {
            throw new IOException(e);
        }
    }
}

