/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeDefinition;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.IoUtil;
import org.modeshape.jcr.CndImporter;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.value.NamespaceRegistry;

public final class NodeTypesImporter {
    protected static final Logger LOGGER = Logger.getLogger(NodeTypesImporter.class);
    protected final JcrRepository.RunningState runningState;
    private final List<String> nodeTypesFiles;

    public NodeTypesImporter(List<String> nodeTypesFiles, JcrRepository.RunningState runningState) {
        this.nodeTypesFiles = nodeTypesFiles;
        this.runningState = runningState;
    }

    void importNodeTypes() throws RepositoryException {
        if (this.nodeTypesFiles.isEmpty()) {
            return;
        }
        ArrayList<NodeTypeDefinition> nodeTypeDefinitions = new ArrayList<NodeTypeDefinition>();
        HashSet<NamespaceRegistry.Namespace> namespaces = new HashSet<NamespaceRegistry.Namespace>();
        for (String cndFile : this.nodeTypesFiles) {
            CndImportOperation cndImportOperation = new CndImportOperation();
            cndImportOperation.execute(cndFile);
            nodeTypeDefinitions.addAll(cndImportOperation.getNodeTypeDefinitions());
            namespaces.addAll(cndImportOperation.getNamespaces());
        }
        if (!nodeTypeDefinitions.isEmpty()) {
            this.runningState.nodeTypeManager().registerNodeTypes(nodeTypeDefinitions, false, false, true);
        }
        if (!namespaces.isEmpty()) {
            this.runningState.persistentRegistry().register(namespaces);
        }
    }

    private final class CndImportOperation {
        private List<NodeTypeDefinition> nodeTypeDefinitions = Collections.emptyList();
        private Set<NamespaceRegistry.Namespace> namespaces = Collections.emptySet();

        protected CndImportOperation() {
        }

        void execute(String cndFile) {
            try {
                InputStream cndFileStream = this.getInputStreamForFile(cndFile);
                if (cndFileStream == null) {
                    LOGGER.warn((I18nResource)JcrI18n.cannotLoadCndFile, new Object[]{cndFile});
                    return;
                }
                CndImporter cndImporter = new CndImporter(NodeTypesImporter.this.runningState.context(), true);
                SimpleProblems importProblems = new SimpleProblems();
                cndImporter.importFrom(cndFileStream, (Problems)importProblems, cndFile);
                if (importProblems.hasErrors()) {
                    importProblems.writeTo(LOGGER);
                    return;
                }
                this.nodeTypeDefinitions = cndImporter.getNodeTypeDefinitions();
                this.namespaces = cndImporter.getNamespaces();
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e, (I18nResource)JcrI18n.errorReadingCndFile, new Object[]{cndFile});
            }
        }

        private InputStream getInputStreamForFile(String cndFileString) {
            return IoUtil.getResourceAsStream((String)cndFileString, (ClassLoader)NodeTypesImporter.this.runningState.environment().getClassLoader(NodeTypesImporter.class.getClassLoader(), new String[0]), null);
        }

        Set<NamespaceRegistry.Namespace> getNamespaces() {
            return this.namespaces;
        }

        List<NodeTypeDefinition> getNodeTypeDefinitions() {
            return this.nodeTypeDefinitions;
        }
    }
}

