/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.infinispan.util.ReflectionUtil;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.HashCode;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.ExtensionLogger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.RepositoryI18n;
import org.modeshape.jcr.RepositoryStatistics;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.PropertyAdded;
import org.modeshape.jcr.cache.change.PropertyChanged;
import org.modeshape.jcr.cache.change.WorkspaceAdded;
import org.modeshape.jcr.cache.change.WorkspaceRemoved;
import org.modeshape.jcr.sequencer.InvalidSequencerPathExpression;
import org.modeshape.jcr.sequencer.SequencerPathExpression;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.ValueFactory;

@Immutable
public class Sequencers
implements ChangeSetListener {
    private static final Logger LOGGER = Logger.getLogger((String)"org.modeshape.jcr.sequencing.sequencers");
    private static final boolean TRACE = LOGGER.isTraceEnabled();
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private final JcrRepository.RunningState repository;
    private final Map<UUID, Sequencer> sequencersById;
    private final Collection<RepositoryConfiguration.Component> components;
    private final Lock configChangeLock = new ReentrantLock();
    private final Map<UUID, Collection<SequencerPathExpression>> pathExpressionsBySequencerId;
    private volatile Map<String, Collection<SequencingConfiguration>> configByWorkspaceName;
    private final String systemWorkspaceKey;
    private final String processId;
    private final ValueFactory<String> stringFactory;
    private final WorkQueue workQueue;
    private boolean initialized;
    private volatile boolean shutdown = false;

    public Sequencers(JcrRepository.RunningState repository, Collection<RepositoryConfiguration.Component> components, Iterable<String> workspaceNames, WorkQueue workQueue) {
        this.repository = repository;
        this.components = components;
        this.workQueue = workQueue;
        this.systemWorkspaceKey = repository.repositoryCache().getSystemKey().getWorkspaceKey();
        if (components.isEmpty()) {
            this.processId = null;
            this.stringFactory = null;
            this.configByWorkspaceName = null;
            this.sequencersById = null;
            this.pathExpressionsBySequencerId = null;
            this.initialized = true;
        } else {
            assert (workQueue != null);
            this.processId = repository.context().getProcessId();
            ExecutionContext context = this.repository.context();
            this.stringFactory = context.getValueFactories().getStringFactory();
            this.sequencersById = new HashMap<UUID, Sequencer>();
            this.configByWorkspaceName = new HashMap<String, Collection<SequencingConfiguration>>();
            this.pathExpressionsBySequencerId = new HashMap<UUID, Collection<SequencerPathExpression>>();
            String repoName = repository.name();
            for (RepositoryConfiguration.Component component : components) {
                try {
                    Sequencer sequencer = (Sequencer)component.createInstance(this.getClass().getClassLoader());
                    ReflectionUtil.setValue((Object)sequencer, (String)"repositoryName", (Object)repoName);
                    ReflectionUtil.setValue((Object)sequencer, (String)"logger", (Object)ExtensionLogger.getLogger(sequencer.getClass()));
                    UUID uuid = sequencer.getUniqueId();
                    this.sequencersById.put(sequencer.getUniqueId(), sequencer);
                    Set<SequencerPathExpression> pathExpressions = this.buildPathExpressionSet(sequencer);
                    this.pathExpressionsBySequencerId.put(uuid, pathExpressions);
                    if (!DEBUG) continue;
                    LOGGER.debug("Created sequencer '{0}' in repository '{1}' with valid path expressions: {2}", new Object[]{sequencer.getName(), repository.name(), pathExpressions});
                }
                catch (Throwable t) {
                    if (t.getCause() != null) {
                        t = t.getCause();
                    }
                    LOGGER.error(t, (I18nResource)JcrI18n.unableToInitializeSequencer, new Object[]{component, repoName, t.getMessage()});
                }
            }
            for (String workspaceName : workspaceNames) {
                this.workspaceAdded(workspaceName);
            }
            this.initialized = false;
        }
    }

    private Sequencers(Sequencers original, JcrRepository.RunningState repository) {
        this.repository = repository;
        this.workQueue = original.workQueue;
        this.systemWorkspaceKey = original.systemWorkspaceKey;
        this.processId = original.processId;
        this.stringFactory = repository.context().getValueFactories().getStringFactory();
        this.components = original.components;
        this.sequencersById = original.sequencersById;
        this.configByWorkspaceName = original.configByWorkspaceName;
        this.pathExpressionsBySequencerId = original.pathExpressionsBySequencerId;
    }

    protected Sequencers with(JcrRepository.RunningState repository) {
        return repository == this.repository ? this : new Sequencers(this, repository);
    }

    protected void initialize() {
        if (this.initialized) {
            return;
        }
        Session session = null;
        try {
            session = this.repository.loginInternalSession();
            NamespaceRegistry registry = session.getWorkspace().getNamespaceRegistry();
            javax.jcr.nodetype.NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
            if (!(nodeTypeManager instanceof NodeTypeManager)) {
                throw new IllegalStateException("Invalid node type manager (expected modeshape NodeTypeManager): " + nodeTypeManager.getClass().getName());
            }
            Iterator<Map.Entry<UUID, Sequencer>> sequencersIterator = this.sequencersById.entrySet().iterator();
            while (sequencersIterator.hasNext()) {
                Sequencer sequencer = sequencersIterator.next().getValue();
                try {
                    sequencer.initialize(registry, (NodeTypeManager)nodeTypeManager);
                    Method postInitialize = ReflectionUtil.findMethod(Sequencer.class, (String)"postInitialize");
                    ReflectionUtil.invokeAccessibly((Object)sequencer, (Method)postInitialize, (Object[])new Object[0]);
                    if (!DEBUG) continue;
                    LOGGER.debug("Successfully initialized sequencer '{0}' in repository '{1}'", new Object[]{sequencer.getName(), this.repository.name()});
                }
                catch (Throwable t) {
                    if (t.getCause() != null) {
                        t = t.getCause();
                    }
                    LOGGER.error(t, (I18nResource)JcrI18n.unableToInitializeSequencer, new Object[]{sequencer, this.repository.name(), t.getMessage()});
                    sequencersIterator.remove();
                }
            }
        }
        catch (RepositoryException e) {
            throw new SystemFailureException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public boolean isEmpty() {
        return this.components.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void workspaceAdded(String workspaceName) {
        String workspaceKey = NodeKey.keyForWorkspaceName((String)workspaceName);
        if (this.systemWorkspaceKey.equals(workspaceKey)) {
            return;
        }
        LinkedList<SequencingConfiguration> configs = new LinkedList<SequencingConfiguration>();
        for (Sequencer sequencer : this.sequencersById.values()) {
            boolean updated = false;
            for (SequencerPathExpression expression : this.pathExpressionsBySequencerId.get(sequencer.getUniqueId())) {
                if (!expression.appliesToWorkspace(workspaceName)) continue;
                updated = true;
                configs.add(new SequencingConfiguration(expression, sequencer));
            }
            if (!DEBUG || !updated) continue;
            LOGGER.debug("Updated sequencer '{0}' (id={1}) configuration due to new workspace '{2}' in repository '{3}'", new Object[]{sequencer.getName(), sequencer.getUniqueId(), workspaceName, this.repository.name()});
        }
        if (configs.isEmpty()) {
            return;
        }
        try {
            this.configChangeLock.lock();
            HashMap<String, Collection<SequencingConfiguration>> configByWorkspaceName = new HashMap<String, Collection<SequencingConfiguration>>(this.configByWorkspaceName);
            configByWorkspaceName.put(workspaceName, configs);
            this.configByWorkspaceName = configByWorkspaceName;
        }
        finally {
            this.configChangeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void workspaceRemoved(String workspaceName) {
        try {
            this.configChangeLock.lock();
            HashMap<String, Collection<SequencingConfiguration>> configByWorkspaceName = new HashMap<String, Collection<SequencingConfiguration>>(this.configByWorkspaceName);
            if (configByWorkspaceName.remove(workspaceName) != null) {
                this.configByWorkspaceName = configByWorkspaceName;
            }
        }
        finally {
            this.configChangeLock.unlock();
        }
    }

    protected final ValueFactory<String> stringFactory() {
        return this.stringFactory;
    }

    protected final void shutdown() {
        this.repository.sequencingQueue().shutdown();
        this.shutdown = true;
    }

    protected final RepositoryStatistics statistics() {
        return this.repository.statistics();
    }

    protected void submitWork(SequencingConfiguration sequencingConfig, SequencerPathExpression.Matcher matcher, String inputWorkspaceName, String propertyName, String userId) {
        if (this.shutdown) {
            return;
        }
        SequencingWorkItem workItem = new SequencingWorkItem(sequencingConfig.getSequencer().getUniqueId(), userId, inputWorkspaceName, matcher.getSelectedPath(), matcher.getJcrInputPath(), matcher.getOutputPath(), matcher.getOutputWorkspaceName(), propertyName);
        this.statistics().increment(ValueMetric.SEQUENCER_QUEUE_SIZE);
        this.workQueue.submit(workItem);
    }

    public Sequencer getSequencer(UUID id) {
        return this.sequencersById.get(id);
    }

    protected Set<SequencerPathExpression> buildPathExpressionSet(Sequencer sequencer) throws InvalidSequencerPathExpression {
        String[] pathExpressions = sequencer.getPathExpressions();
        if (pathExpressions.length == 0) {
            String msg = RepositoryI18n.atLeastOneSequencerPathExpressionMustBeSpecified.text(new Object[]{this.repository.name(), sequencer.getName()});
            throw new InvalidSequencerPathExpression(msg);
        }
        LinkedHashSet<SequencerPathExpression> result = new LinkedHashSet<SequencerPathExpression>();
        for (String pathExpression : pathExpressions) {
            assert (pathExpression != null);
            assert (pathExpression.length() != 0);
            SequencerPathExpression expression = SequencerPathExpression.compile((String)pathExpression);
            result.add(expression);
        }
        return Collections.unmodifiableSet(result);
    }

    public void notify(ChangeSet changeSet) {
        if (this.processId == null) {
            return;
        }
        if (!this.processId.equals(changeSet.getProcessKey())) {
            return;
        }
        String workspaceName = changeSet.getWorkspaceName();
        Collection<SequencingConfiguration> configs = this.configByWorkspaceName.get(workspaceName);
        if (configs == null) {
            return;
        }
        try {
            for (Change change : changeSet) {
                SequencerPathExpression.Matcher matcher;
                Name propName;
                String strPath;
                Path nodePath;
                PropertyAdded added;
                if (change instanceof PropertyAdded) {
                    added = (PropertyAdded)change;
                    nodePath = added.getPathToNode();
                    strPath = (String)this.stringFactory.create(nodePath);
                    propName = added.getProperty().getName();
                    for (SequencingConfiguration config : configs) {
                        matcher = config.matches(strPath, propName);
                        if (!matcher.matches()) {
                            if (!TRACE) continue;
                            LOGGER.trace("Added property '{1}:{0}' in repository '{2}' did not match sequencer '{3}' and path expression '{4}'", new Object[]{added.getPath(), workspaceName, this.repository.name(), config.getSequencer().getName(), config.getPathExpression()});
                            continue;
                        }
                        if (TRACE) {
                            LOGGER.trace("Submitting added property '{1}:{0}' in repository '{2}' for sequencing using '{3}' and path expression '{4}'", new Object[]{added.getPath(), workspaceName, this.repository.name(), config.getSequencer().getName(), config.getPathExpression()});
                        }
                        this.submitWork(config, matcher, workspaceName, (String)this.stringFactory.create(propName), changeSet.getUserId());
                    }
                    continue;
                }
                if (change instanceof PropertyChanged) {
                    PropertyChanged changed = (PropertyChanged)change;
                    nodePath = changed.getPathToNode();
                    strPath = (String)this.stringFactory.create(nodePath);
                    propName = changed.getNewProperty().getName();
                    for (SequencingConfiguration config : configs) {
                        matcher = config.matches(strPath, propName);
                        if (!matcher.matches()) {
                            if (!TRACE) continue;
                            LOGGER.trace("Changed property '{1}:{0}' in repository '{2}' did not match sequencer '{3}' and path expression '{4}'", new Object[]{changed.getPath(), workspaceName, this.repository.name(), config.getSequencer().getName(), config.getPathExpression()});
                            continue;
                        }
                        if (TRACE) {
                            LOGGER.trace("Submitting changed property '{1}:{0}' in repository '{2}' for sequencing using '{3}' and path expression '{4}'", new Object[]{changed.getPath(), workspaceName, this.repository.name(), config.getSequencer().getName(), config.getPathExpression()});
                        }
                        this.submitWork(config, matcher, workspaceName, (String)this.stringFactory.create(propName), changeSet.getUserId());
                    }
                    continue;
                }
                if (change instanceof WorkspaceAdded) {
                    added = (WorkspaceAdded)change;
                    this.workspaceAdded(added.getWorkspaceName());
                    continue;
                }
                if (!(change instanceof WorkspaceRemoved)) continue;
                WorkspaceRemoved removed = (WorkspaceRemoved)change;
                this.workspaceRemoved(removed.getWorkspaceName());
            }
        }
        catch (Throwable e) {
            LOGGER.error(e, (I18nResource)JcrI18n.errorCleaningUpLocks, new Object[]{this.repository.name()});
        }
    }

    @Immutable
    public static final class SequencingWorkItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final UUID sequencerId;
        private final String inputWorkspaceName;
        private final String selectedPath;
        private final String inputPath;
        private final String changedPropertyName;
        private final String outputPath;
        private final String outputWorkspaceName;
        private final int hc;
        private final String userId;

        protected SequencingWorkItem(UUID sequencerId, String userId, String inputWorkspaceName, String selectedPath, String inputPath, String outputPath, String outputWorkspaceName, String changedPropertyName) {
            this.userId = userId;
            this.sequencerId = sequencerId;
            this.inputWorkspaceName = inputWorkspaceName;
            this.selectedPath = selectedPath;
            this.inputPath = inputPath;
            this.outputPath = outputPath;
            this.outputWorkspaceName = outputWorkspaceName;
            this.changedPropertyName = changedPropertyName;
            this.hc = HashCode.compute((Object[])new Object[]{this.sequencerId, this.inputWorkspaceName, this.inputPath, this.changedPropertyName, this.outputPath, this.outputWorkspaceName});
            assert (this.sequencerId != null);
            assert (this.inputPath != null);
            assert (this.changedPropertyName != null);
            assert (this.outputPath != null);
        }

        public UUID getSequencerId() {
            return this.sequencerId;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getInputWorkspaceName() {
            return this.inputWorkspaceName;
        }

        public String getInputPath() {
            return this.inputPath;
        }

        public String getSelectedPath() {
            return this.selectedPath;
        }

        public String getChangedPropertyName() {
            return this.changedPropertyName;
        }

        public String getOutputPath() {
            return this.outputPath;
        }

        public String getOutputWorkspaceName() {
            return this.outputWorkspaceName;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SequencingWorkItem) {
                SequencingWorkItem that = (SequencingWorkItem)obj;
                if (this.hc != that.hc) {
                    return false;
                }
                if (!this.sequencerId.equals(that.sequencerId)) {
                    return false;
                }
                if (!this.inputWorkspaceName.equals(that.inputWorkspaceName)) {
                    return false;
                }
                if (!this.inputPath.equals(that.inputPath)) {
                    return false;
                }
                if (!this.outputPath.equals(that.outputWorkspaceName)) {
                    return false;
                }
                return this.outputWorkspaceName.equals(that.outputWorkspaceName);
            }
            return false;
        }

        public String toString() {
            return this.sequencerId + " @ " + this.inputPath + " -> " + this.outputPath + (this.outputWorkspaceName != null ? " in workspace '" + this.outputWorkspaceName + "'" : "");
        }
    }

    protected final class SequencingConfiguration {
        private final Sequencer sequencer;
        private final SequencerPathExpression pathExpression;

        protected SequencingConfiguration(SequencerPathExpression expression, Sequencer sequencer) {
            this.sequencer = sequencer;
            this.pathExpression = expression;
        }

        public SequencerPathExpression getPathExpression() {
            return this.pathExpression;
        }

        public Sequencer getSequencer() {
            return this.sequencer;
        }

        public SequencerPathExpression.Matcher matches(String pathToChangedNode, Name changedPropertyName) {
            String absolutePath = pathToChangedNode + "/@" + (String)Sequencers.this.stringFactory().create(changedPropertyName);
            return this.pathExpression.matcher(absolutePath);
        }
    }

    public static interface WorkQueue {
        public void submit(SequencingWorkItem var1);
    }

    @Immutable
    protected static final class SequencingContext
    implements Sequencer.Context {
        private final DateTime now;
        private final org.modeshape.jcr.api.ValueFactory valueFactory;

        protected SequencingContext(DateTime now, org.modeshape.jcr.api.ValueFactory jcrValueFactory) {
            this.now = now;
            this.valueFactory = jcrValueFactory;
        }

        public Calendar getTimestamp() {
            return this.now.toCalendar();
        }

        public org.modeshape.jcr.api.ValueFactory valueFactory() {
            return this.valueFactory;
        }
    }
}

