/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.jcr.FedoraJcrTypes;
import org.fcrepo.kernel.FedoraObject;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.exception.InvalidChecksumException;
import org.fcrepo.kernel.services.ServiceHelpers;
import org.fcrepo.kernel.services.policy.StoragePolicyDecisionPoint;
import org.fcrepo.kernel.utils.ContentDigest;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.fcrepo.metrics.RegistryService;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Datastream
extends FedoraResource
implements FedoraJcrTypes {
    private static final Logger LOGGER = LoggerFactory.getLogger(Datastream.class);
    static final Histogram contentSizeHistogram = RegistryService.getMetrics().histogram(MetricRegistry.name(Datastream.class, (String[])new String[]{"content-size"}));

    public Datastream(Node n) {
        super(n);
        if (this.node.isNew()) {
            this.initializeNewDatastreamProperties();
        }
    }

    public Datastream(Session session, String path, String nodeType) throws RepositoryException {
        super(session, path, nodeType);
        if (this.node.isNew()) {
            this.initializeNewDatastreamProperties();
        }
    }

    public Datastream(Session session, String path) throws RepositoryException {
        this(session, path, "nt:file");
    }

    private void initializeNewDatastreamProperties() {
        try {
            if (this.node.isNew() || !Datastream.hasMixin(this.node)) {
                LOGGER.debug("Setting {} properties on a {} node...", (Object)"fedora:datastream", (Object)"nt:file");
                this.node.addMixin("fedora:datastream");
                if (this.node.hasNode("jcr:content")) {
                    Node contentNode = this.node.getNode("jcr:content");
                    this.decorateContentNode(contentNode);
                }
            }
        }
        catch (RepositoryException ex) {
            LOGGER.warn("Could not decorate {} with {} properties: {}", new Object[]{"jcr:content", "fedora:datastream", ex});
        }
    }

    public InputStream getContent() throws RepositoryException {
        Node contentNode = this.node.getNode("jcr:content");
        LOGGER.trace("Retrieved datastream content node.");
        return contentNode.getProperty("jcr:data").getBinary().getStream();
    }

    public void setContent(InputStream content, String contentType, URI checksum, String originalFileName, StoragePolicyDecisionPoint storagePolicyDecisionPoint) throws RepositoryException, InvalidChecksumException {
        Node contentNode = this.findOrCreateChild(this.node, "jcr:content", "nt:resource");
        if (contentNode.canAddMixin("fedora:binary")) {
            contentNode.addMixin("fedora:binary");
        }
        if (contentType != null) {
            contentNode.setProperty("jcr:mimeType", contentType);
        }
        if (originalFileName != null) {
            contentNode.setProperty("premis:hasOriginalName", originalFileName);
        }
        LOGGER.debug("Created content node at path: {}", (Object)contentNode.getPath());
        String hint = null;
        if (storagePolicyDecisionPoint != null) {
            hint = storagePolicyDecisionPoint.evaluatePolicies(this.node);
        }
        ValueFactory modevf = (ValueFactory)this.node.getSession().getValueFactory();
        Binary binary = modevf.createBinary(content, hint);
        Property dataProperty = contentNode.setProperty("jcr:data", (javax.jcr.Binary)binary);
        String dsChecksum = binary.getHexHash();
        URI uriChecksumString = ContentDigest.asURI("SHA-1", dsChecksum);
        if (checksum != null && !checksum.equals(uriChecksumString)) {
            LOGGER.debug("Failed checksum test");
            throw new InvalidChecksumException("Checksum Mismatch of " + uriChecksumString + " and " + checksum);
        }
        this.decorateContentNode(contentNode);
        LOGGER.debug("Created data property at path: {}", (Object)dataProperty.getPath());
    }

    public void setContent(InputStream content) throws InvalidChecksumException, RepositoryException {
        this.setContent(content, null, null, null, null);
    }

    public long getContentSize() {
        try {
            return this.node.getNode("jcr:content").getProperty("premis:hasSize").getLong();
        }
        catch (RepositoryException e) {
            LOGGER.info("Could not get contentSize()", (Throwable)e);
            return -1L;
        }
    }

    public URI getContentDigest() throws RepositoryException {
        Node contentNode = this.node.getNode("jcr:content");
        try {
            return new URI(contentNode.getProperty("fedora:digest").getString());
        }
        catch (URISyntaxException | RepositoryException e) {
            LOGGER.info("Could not get content digest: ", e);
            return ContentDigest.missingChecksum();
        }
    }

    public String getDsId() throws RepositoryException {
        return this.node.getName();
    }

    public FedoraObject getObject() throws RepositoryException {
        return new FedoraObject(this.node.getParent());
    }

    public String getMimeType() throws RepositoryException {
        return this.node.hasNode("jcr:content") && this.node.getNode("jcr:content").hasProperty("jcr:mimeType") ? this.node.getNode("jcr:content").getProperty("jcr:mimeType").getString() : "application/octet-stream";
    }

    @Override
    public long getSize() throws RepositoryException {
        return ServiceHelpers.getNodePropertySize(this.node) + this.getContentSize();
    }

    public String getFilename() throws RepositoryException {
        if (this.node.hasNode("jcr:content") && this.node.getNode("jcr:content").hasProperty("premis:hasOriginalName")) {
            return this.node.getNode("jcr:content").getProperty("premis:hasOriginalName").getString();
        }
        return this.getDsId();
    }

    private void decorateContentNode(Node contentNode) throws RepositoryException {
        if (contentNode == null) {
            LOGGER.warn("{} node appears to be null!", (Object)"jcr:content");
            return;
        }
        if (contentNode.canAddMixin("fedora:binary")) {
            contentNode.addMixin("fedora:binary");
        }
        Property dataProperty = contentNode.getProperty("jcr:data");
        Binary binary = (Binary)dataProperty.getBinary();
        String dsChecksum = binary.getHexHash();
        contentSizeHistogram.update(dataProperty.getLength());
        contentNode.setProperty("premis:hasSize", dataProperty.getLength());
        contentNode.setProperty("fedora:digest", ContentDigest.asURI("SHA-1", dsChecksum).toString());
        LOGGER.debug("Decorated data property at path: {}", (Object)dataProperty.getPath());
    }

    public static boolean hasMixin(Node node) throws RepositoryException {
        return FedoraTypesUtils.isFedoraDatastream.apply((Object)node);
    }
}

