/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraObject
extends FedoraResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraObject.class);

    public FedoraObject(Node node) {
        super(node);
        if (node.isNew()) {
            this.initializeNewObjectProperties();
        }
    }

    public FedoraObject(Session session, String path, String nodeType) throws RepositoryException {
        super(session, path, nodeType);
        if (this.node.isNew()) {
            this.initializeNewObjectProperties();
        }
    }

    public FedoraObject(Session session, String path) throws RepositoryException {
        this(session, path, "nt:folder");
    }

    private void initializeNewObjectProperties() {
        try {
            if (this.node.isNew() || !FedoraObject.hasMixin(this.node)) {
                LOGGER.debug("Setting {} properties on a {} node {}...", new Object[]{"fedora:object", "nt:folder", this.node.getPath()});
                this.node.addMixin("fedora:object");
            }
        }
        catch (RepositoryException e) {
            LOGGER.warn("Could not decorate {} with {} properties: {} ", new Object[]{"jcr:content", "fedora:object", e});
        }
    }

    public String getName() throws RepositoryException {
        return this.node.getName();
    }

    public static boolean hasMixin(Node node) throws RepositoryException {
        return FedoraTypesUtils.isFedoraObject.apply((Object)node);
    }
}

