/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.TxAwareSession;
import org.fcrepo.kernel.services.VersionService;

public class Transaction {
    public static final long DEFAULT_TIMEOUT = 180000L;
    public static final String TIMEOUT_SYSTEM_PROPERTY = "fcrepo4.tx.timeout";
    private final Session session;
    private final String id;
    private final Date created;
    private Calendar expires;
    private State state = State.NEW;
    private Set<String> versionedPaths;

    public Transaction(Session session) {
        this.session = session;
        this.created = new Date();
        this.id = UUID.randomUUID().toString();
        this.expires = Calendar.getInstance();
        this.updateExpiryDate();
    }

    public Session getSession() {
        this.updateExpiryDate();
        return TxAwareSession.newInstance(this.session, this.id);
    }

    public Date getCreated() {
        return new Date(this.created.getTime());
    }

    public String getId() {
        return this.id;
    }

    public State getState() throws RepositoryException {
        if (this.session != null && this.session.hasPendingChanges()) {
            return State.DIRTY;
        }
        return this.state;
    }

    public Date getExpires() {
        return this.expires.getTime();
    }

    public void addPathToVersion(String absPath) {
        if (this.versionedPaths == null) {
            this.versionedPaths = Collections.newSetFromMap(new ConcurrentHashMap());
        }
        this.versionedPaths.add(absPath);
    }

    public void commit(VersionService vService) throws RepositoryException {
        this.session.save();
        if (this.versionedPaths != null) {
            if (vService == null) {
                throw new IllegalStateException("Versioned Paths were added, but no VersionService was provided!");
            }
            vService.createVersion(this.session.getWorkspace(), this.versionedPaths);
        }
        this.state = State.COMMITED;
        this.expire();
    }

    public void expire() throws RepositoryException {
        this.session.logout();
        this.expires.setTimeInMillis(System.currentTimeMillis());
    }

    public void rollback() throws RepositoryException {
        this.state = State.ROLLED_BACK;
        this.session.refresh(false);
        this.expire();
    }

    public void updateExpiryDate() {
        long duration = System.getProperty(TIMEOUT_SYSTEM_PROPERTY) != null ? Long.parseLong(System.getProperty(TIMEOUT_SYSTEM_PROPERTY)) : 180000L;
        this.expires.setTimeInMillis(System.currentTimeMillis() + duration);
    }

    public static enum State {
        DIRTY,
        NEW,
        COMMITED,
        ROLLED_BACK;

    }
}

