/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jcr.Session;
import org.fcrepo.kernel.TxSession;

public class TxAwareSession
implements InvocationHandler {
    private final String txId;
    private Session session;

    public TxAwareSession(Session session, String txID) {
        this.session = session;
        this.txId = txID;
    }

    public static Session newInstance(Session session, String txId) {
        return (Session)Proxy.newProxyInstance(session.getClass().getClassLoader(), new Class[]{TxSession.class}, (InvocationHandler)new TxAwareSession(session, txId));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws ReflectiveOperationException {
        if (method.getName().equals("logout") || method.getName().equals("save")) {
            return null;
        }
        if (method.getName().equals("getTxId")) {
            return this.txId;
        }
        if (method.getName().equals("impersonate")) {
            return TxAwareSession.newInstance((Session)method.invoke((Object)this.session, args), this.txId);
        }
        return method.invoke((Object)this.session, args);
    }
}

