/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.observer;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.observer.EventFilter;
import org.fcrepo.kernel.observer.FedoraEvent;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFilter
implements EventFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFilter.class);
    private Session session;

    public DefaultFilter() {
    }

    private DefaultFilter(Session session) {
        this.session = session;
    }

    @Override
    public Function<Event, Event> getFilter(Session session) {
        return new DefaultFilter(session);
    }

    public Event apply(Event event) {
        try {
            String nPath = event.getPath();
            int nType = event.getType();
            switch (nType) {
                case 1: {
                    break;
                }
                case 2: {
                    return event;
                }
                case 4: {
                    nPath = nPath.substring(0, nPath.lastIndexOf(47));
                    break;
                }
                case 8: {
                    nPath = nPath.substring(0, nPath.lastIndexOf(47));
                    break;
                }
                case 16: {
                    nPath = nPath.substring(0, nPath.lastIndexOf(47));
                    break;
                }
                case 32: {
                    break;
                }
                default: {
                    return null;
                }
            }
            Node n = this.session.getNode(nPath);
            if (FedoraTypesUtils.isFedoraObject.apply((Object)n)) {
                return new FedoraEvent(event, "fedora:object");
            }
            if (FedoraTypesUtils.isFedoraDatastream.apply((Object)n)) {
                return new FedoraEvent(event, "fedora:datastream");
            }
        }
        catch (PathNotFoundException e) {
            LOGGER.trace("Dropping event from outside our assigned workspace", (Throwable)e);
            return null;
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return null;
    }
}

