/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.observer;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.utils.EventType;

public class FedoraEvent
implements Event {
    public static final String NODE_TYPE_KEY = "fedora:nodeTypeKey";
    private Event e;
    private String nodeType;
    private Map<Object, Object> memoizedInfo;

    public FedoraEvent(Event e) {
        this(e, null);
    }

    public FedoraEvent(Event e, String wrappedNodeType) {
        Preconditions.checkArgument((e != null ? 1 : 0) != 0, (Object)"null cannot support a FedoraEvent!");
        this.e = e;
        this.nodeType = wrappedNodeType;
    }

    public int getType() {
        return this.e.getType();
    }

    public String getPath() throws RepositoryException {
        return this.e.getPath();
    }

    public String getUserID() {
        return this.e.getUserID();
    }

    public String getIdentifier() throws RepositoryException {
        return this.e.getIdentifier();
    }

    public Map<?, ?> getInfo() throws RepositoryException {
        if (this.memoizedInfo == null) {
            this.memoizedInfo = new HashMap<Object, Object>(this.e.getInfo());
            this.memoizedInfo.put(NODE_TYPE_KEY, this.nodeType);
        }
        return this.memoizedInfo;
    }

    public String getUserData() throws RepositoryException {
        return this.e.getUserData();
    }

    public long getDate() throws RepositoryException {
        return this.e.getDate();
    }

    public String toString() {
        try {
            return Objects.toStringHelper((Object)this).add("Event type:", (Object)("http://fedora.info/definitions/v4/repository#" + (Object)((Object)EventType.valueOf(this.getType())))).add("Path:", (Object)this.getPath()).add("Date: ", this.getDate()).add("Info:", this.getInfo()).toString();
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

