/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.observer;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.EventBus;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventListener;
import org.fcrepo.kernel.observer.EventFilter;
import org.fcrepo.kernel.utils.iterators.EventIterator;
import org.fcrepo.metrics.RegistryService;
import org.modeshape.jcr.api.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleObserver
implements EventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleObserver.class);
    static final Counter EVENT_COUNTER = RegistryService.getMetrics().counter(MetricRegistry.name(SimpleObserver.class, (String[])new String[]{"onEvent"}));
    static final Integer EVENT_TYPES = 63;
    @Inject
    private Repository repository;
    @Inject
    private EventBus eventBus;
    @Inject
    private EventFilter eventFilter;
    private Session session;

    @PostConstruct
    public void buildListener() throws RepositoryException {
        this.session = this.repository.login();
        this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, EVENT_TYPES.intValue(), "/", true, null, null, false);
        this.session.save();
    }

    @PreDestroy
    public void stopListening() throws RepositoryException {
        this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        this.session.logout();
    }

    public void onEvent(javax.jcr.observation.EventIterator events) {
        HashSet<String> posted = new HashSet<String>((int)events.getSize() * 2 / 3);
        Session lookupSession = null;
        try {
            lookupSession = this.repository.login();
            for (Event e : Iterables.transform((Iterable)new EventIterator(events), this.eventFilter.getFilter(lookupSession))) {
                String nodePath;
                if (e == null) continue;
                String eventPath = e.getPath();
                int nType = e.getType();
                switch (nType) {
                    case 1: 
                    case 2: 
                    case 32: {
                        nodePath = eventPath;
                        break;
                    }
                    case 4: 
                    case 8: 
                    case 16: {
                        nodePath = eventPath.substring(0, eventPath.lastIndexOf(47));
                        break;
                    }
                    default: {
                        nodePath = null;
                    }
                }
                if (nodePath != null && !posted.contains(nodePath)) {
                    EVENT_COUNTER.inc();
                    LOGGER.debug("Putting event: {} ({}) on the bus", (Object)nodePath, (Object)nType);
                    this.eventBus.post((Object)e);
                    posted.add(nodePath);
                    continue;
                }
                LOGGER.debug("Skipping event: {} ({}) on the bus", (Object)nodePath, (Object)nType);
            }
        }
        catch (RepositoryException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
        finally {
            if (lookupSession != null) {
                lookupSession.logout();
            }
        }
    }
}

