/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Calendar;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.fcrepo.kernel.utils.FixityResult;

public class FixityRdfContext
extends NodeRdfContext {
    public FixityRdfContext(final javax.jcr.Node node, final GraphSubjects graphSubjects, LowLevelStorageService lowLevelStorageService, Iterable<FixityResult> blobs) throws RepositoryException {
        super(node, graphSubjects, lowLevelStorageService);
        this.concat(Iterators.concat((Iterator)Iterators.transform(blobs.iterator(), (Function)new Function<FixityResult, Iterator<Triple>>(){

            public Iterator<Triple> apply(FixityResult blob) {
                Node resultSubject = FixityRdfContext.this.getTransientFixitySubject();
                ImmutableSet.Builder b = ImmutableSet.builder();
                try {
                    b.add((Object)Triple.create((Node)resultSubject, (Node)RDF.type.asNode(), (Node)RdfLexicon.FIXITY_TYPE.asNode()));
                    b.add((Object)Triple.create((Node)graphSubjects.getGraphSubject(node).asNode(), (Node)RdfLexicon.HAS_FIXITY_RESULT.asNode(), (Node)resultSubject));
                    String storeIdentifier = blob.getStoreIdentifier();
                    Node contentLocation = ResourceFactory.createResource((String)storeIdentifier).asNode();
                    b.add((Object)Triple.create((Node)resultSubject, (Node)RdfLexicon.HAS_CONTENT_LOCATION.asNode(), (Node)contentLocation));
                    b.add((Object)Triple.create((Node)contentLocation, (Node)RDF.type.asNode(), (Node)RdfLexicon.CONTENT_LOCATION_TYPE.asNode()));
                    b.add((Object)Triple.create((Node)contentLocation, (Node)RdfLexicon.HAS_CONTENT_LOCATION_VALUE.asNode(), (Node)NodeFactory.createLiteral((String)storeIdentifier)));
                    for (FixityResult.FixityState state : blob.status) {
                        b.add((Object)Triple.create((Node)resultSubject, (Node)RdfLexicon.HAS_FIXITY_STATE.asNode(), (Node)NodeFactory.createLiteral((String)state.toString())));
                    }
                    String checksum = blob.computedChecksum.toString();
                    b.add((Object)Triple.create((Node)resultSubject, (Node)RdfLexicon.HAS_MESSAGE_DIGEST.asNode(), (Node)NodeFactory.createURI((String)checksum)));
                    b.add((Object)Triple.create((Node)resultSubject, (Node)RdfLexicon.HAS_SIZE.asNode(), (Node)ResourceFactory.createTypedLiteral((Object)blob.computedSize).asNode()));
                    return b.build().iterator();
                }
                catch (RepositoryException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        })));
    }

    private Node getTransientFixitySubject() {
        return NodeFactory.createURI((String)(this.subject().getURI() + "#fixity/" + Calendar.getInstance().getTimeInMillis()));
    }
}

