/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.rdf.JcrRdfTools;
import org.fcrepo.kernel.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.rdf.impl.PropertiesRdfContext;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.fcrepo.kernel.utils.iterators.NodeIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyRdfContext
extends NodeRdfContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(HierarchyRdfContext.class);
    private static Predicate<javax.jcr.Node> nastyChildren = new Predicate<javax.jcr.Node>(){

        public boolean apply(javax.jcr.Node n) {
            LOGGER.trace("Testing child node {}", (Object)n);
            try {
                return FedoraTypesUtils.isInternalNode.apply((Object)n) || n.getName().equals("jcr:content");
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };

    public HierarchyRdfContext(javax.jcr.Node node, GraphSubjects graphSubjects, LowLevelStorageService lowLevelStorageService) throws RepositoryException {
        super(node, graphSubjects, lowLevelStorageService);
        if (node.getDepth() > 0) {
            LOGGER.trace("Determined that this node has a parent.");
            this.concat(this.parentContext());
        }
        Node pageContext = graphSubjects.getContext().asNode();
        this.concat(new Triple[]{Triple.create((Node)pageContext, (Node)RDF.type.asNode(), (Node)RdfLexicon.PAGE.asNode()), Triple.create((Node)pageContext, (Node)RdfLexicon.PAGE_OF.asNode(), (Node)this.subject())});
        if (JcrRdfTools.isContainer(node)) {
            LOGGER.trace("Determined that this node is a container.");
            this.concat(this.containerContext(pageContext));
        } else {
            LOGGER.trace("Determined that this node is not a container.");
        }
        if (node.hasNodes()) {
            LOGGER.trace("Found children of this node.");
            this.concat(this.childrenContext(pageContext));
        }
    }

    private Triple[] containerContext(Node pageContext) {
        return new Triple[]{Triple.create((Node)pageContext, (Node)RdfLexicon.MEMBERS_INLINED.asNode(), (Node)NodeFactory.createLiteral((String)Boolean.TRUE.toString())), Triple.create((Node)this.subject(), (Node)RDF.type.asNode(), (Node)RdfLexicon.CONTAINER.asNode()), Triple.create((Node)this.subject(), (Node)RdfLexicon.MEMBERSHIP_SUBJECT.asNode(), (Node)this.subject()), Triple.create((Node)this.subject(), (Node)RdfLexicon.MEMBERSHIP_PREDICATE.asNode(), (Node)RdfLexicon.HAS_CHILD.asNode()), Triple.create((Node)this.subject(), (Node)RdfLexicon.MEMBERSHIP_OBJECT.asNode(), (Node)RdfLexicon.MEMBER_SUBJECT.asNode())};
    }

    private Iterator<Triple> parentContext() throws RepositoryException {
        javax.jcr.Node parentNode = this.node().getParent();
        Node parentNodeSubject = this.graphSubjects().getGraphSubject(parentNode).asNode();
        return new PropertiesRdfContext(parentNode, this.graphSubjects(), this.lowLevelStorageService()).concat(new Triple[]{Triple.create((Node)this.subject(), (Node)RdfLexicon.HAS_PARENT.asNode(), (Node)parentNodeSubject), Triple.create((Node)parentNodeSubject, (Node)RdfLexicon.HAS_CHILD.asNode(), (Node)this.subject()), Triple.create((Node)this.graphSubjects().getContext().asNode(), (Node)RdfLexicon.INLINED_RESOURCE.asNode(), (Node)parentNodeSubject)});
    }

    private Iterator<Triple> childrenContext(Node pageContext) throws RepositoryException {
        UnmodifiableIterator niceChildren = Iterators.filter((Iterator)((Object)new NodeIterator(this.node().getNodes())), (Predicate)Predicates.not(nastyChildren));
        return Iterators.concat((Iterator)Iterators.transform((Iterator)niceChildren, this.child2triples(pageContext)));
    }

    private Function<javax.jcr.Node, Iterator<Triple>> child2triples(final Node pageContext) {
        return new Function<javax.jcr.Node, Iterator<Triple>>(){

            public Iterator<Triple> apply(javax.jcr.Node child) {
                try {
                    Node childSubject = HierarchyRdfContext.this.graphSubjects().getGraphSubject(child).asNode();
                    LOGGER.trace("Creating triples for child node: {}", (Object)child);
                    return new PropertiesRdfContext(child, HierarchyRdfContext.this.graphSubjects(), HierarchyRdfContext.this.lowLevelStorageService()).concat(new Triple[]{Triple.create((Node)pageContext, (Node)RdfLexicon.INLINED_RESOURCE.asNode(), (Node)childSubject), Triple.create((Node)childSubject, (Node)RdfLexicon.HAS_PARENT.asNode(), (Node)HierarchyRdfContext.this.subject()), Triple.create((Node)HierarchyRdfContext.this.subject(), (Node)RdfLexicon.HAS_CHILD.asNode(), (Node)childSubject)});
                }
                catch (RepositoryException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }
}

