/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.rdf.JcrRdfTools;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRdfContext
extends RdfStream {
    private final javax.jcr.Node node;
    private final GraphSubjects graphSubjects;
    private final Node subject;
    private final LowLevelStorageService lowLevelStorageService;
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeRdfContext.class);

    public NodeRdfContext(javax.jcr.Node node, GraphSubjects graphSubjects, LowLevelStorageService lowLevelStorageService) throws RepositoryException {
        this.node = node;
        this.graphSubjects = graphSubjects;
        this.subject = graphSubjects.getGraphSubject(node).asNode();
        if (lowLevelStorageService == null) {
            this.lowLevelStorageService = new LowLevelStorageService();
            this.lowLevelStorageService.setRepository(node.getSession().getRepository());
        } else {
            this.lowLevelStorageService = lowLevelStorageService;
        }
        UnmodifiableIterator nodeTypes = Iterators.forArray((Object[])node.getMixinNodeTypes());
        this.concat(Iterators.transform((Iterator)nodeTypes, this.nodetype2triple()));
    }

    public javax.jcr.Node node() {
        return this.node;
    }

    public GraphSubjects graphSubjects() {
        return this.graphSubjects;
    }

    public Node subject() {
        return this.subject;
    }

    public LowLevelStorageService lowLevelStorageService() {
        return this.lowLevelStorageService;
    }

    private Function<NodeType, Triple> nodetype2triple() {
        return new Function<NodeType, Triple>(){

            public Triple apply(NodeType nodeType) {
                try {
                    String fullTypeName = nodeType.getName();
                    LOGGER.trace("Translating JCR mixin name: {}", (Object)fullTypeName);
                    String prefix = fullTypeName.split(":")[0];
                    String typeName = fullTypeName.split(":")[1];
                    String namespace = NodeRdfContext.this.getJcrUri(prefix);
                    LOGGER.trace("with JCR namespace: {}", (Object)namespace);
                    Node rdfType = NodeFactory.createURI((String)(JcrRdfTools.getRDFNamespaceForJcrNamespace(namespace) + typeName));
                    LOGGER.trace("into RDF resource: {}", (Object)rdfType);
                    return Triple.create((Node)NodeRdfContext.this.subject(), (Node)RDF.type.asNode(), (Node)rdfType);
                }
                catch (RepositoryException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }

    private String getJcrUri(String prefix) throws RepositoryException {
        return this.node().getSession().getWorkspace().getNamespaceRegistry().getURI(prefix);
    }
}

