/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.fcrepo.kernel.rdf.impl.mappings.ItemDefinitionToTriples;
import org.fcrepo.kernel.rdf.impl.mappings.NodeDefinitionToTriples;
import org.fcrepo.kernel.rdf.impl.mappings.PropertyDefinitionToTriples;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.fcrepo.kernel.utils.iterators.NodeTypeIterator;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeRdfContext
extends RdfStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeTypeRdfContext.class);
    private static final Predicate<ItemDefinition> isWildcardResidualDefinition = new Predicate<ItemDefinition>(){

        public boolean apply(ItemDefinition input) {
            return input.getName().equals("*");
        }
    };

    public NodeTypeRdfContext(NodeTypeManager nodeTypeManager) throws RepositoryException {
        this.concat(new NodeTypeRdfContext(new NodeTypeIterator(nodeTypeManager.getPrimaryNodeTypes())));
        this.concat(new NodeTypeRdfContext(new NodeTypeIterator(nodeTypeManager.getMixinNodeTypes())));
    }

    public NodeTypeRdfContext(Iterable<NodeType> nodeTypeIterator) throws RepositoryException {
        for (NodeType t : nodeTypeIterator) {
            this.concat(new NodeTypeRdfContext(t));
        }
    }

    public NodeTypeRdfContext(NodeType nodeType) throws RepositoryException {
        final Node nodeTypeResource = ItemDefinitionToTriples.getResource(nodeType).asNode();
        final String nodeTypeName = nodeType.getName();
        LOGGER.trace("Adding triples for nodeType: {} with URI: {}", (Object)nodeTypeName, (Object)nodeTypeResource.getURI());
        this.concat(FedoraTypesUtils.map(nodeType.getDeclaredSupertypes(), new Function<NodeType, Triple>(){

            public Triple apply(NodeType input) {
                try {
                    Node supertypeNode = ItemDefinitionToTriples.getResource(input).asNode();
                    LOGGER.trace("Adding triple for nodeType: {} with subclass: {}", (Object)nodeTypeName, (Object)supertypeNode.getURI());
                    return Triple.create((Node)nodeTypeResource, (Node)RDFS.subClassOf.asNode(), (Node)supertypeNode);
                }
                catch (RepositoryException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }));
        this.concat(Iterators.concat((Iterator)Iterators.transform((Iterator)Iterators.filter((Iterator)Iterators.forArray((Object[])nodeType.getDeclaredChildNodeDefinitions()), (Predicate)Predicates.not(isWildcardResidualDefinition)), (Function)new NodeDefinitionToTriples(nodeTypeResource))));
        this.concat(Iterators.concat((Iterator)Iterators.transform((Iterator)Iterators.filter((Iterator)Iterators.forArray((Object[])nodeType.getDeclaredPropertyDefinitions()), (Predicate)Predicates.not(isWildcardResidualDefinition)), (Function)new PropertyDefinitionToTriples(nodeTypeResource))));
        this.concat(new Triple[]{Triple.create((Node)nodeTypeResource, (Node)RDF.type.asNode(), (Node)RDFS.Class.asNode()), Triple.create((Node)nodeTypeResource, (Node)RDFS.label.asNode(), (Node)NodeFactory.createLiteral((String)nodeTypeName))});
    }
}

