/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.security.AccessControlException;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.rdf.impl.RootRdfContext;
import org.fcrepo.kernel.rdf.impl.mappings.PropertyToTriple;
import org.fcrepo.kernel.rdf.impl.mappings.ZippingIterator;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.fcrepo.kernel.utils.iterators.PropertyIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesRdfContext
extends NodeRdfContext {
    private PropertyToTriple property2triple;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesRdfContext.class);

    public PropertiesRdfContext(javax.jcr.Node node, GraphSubjects graphSubjects, LowLevelStorageService lowLevelStorageService) throws RepositoryException {
        super(node, graphSubjects, lowLevelStorageService);
        this.property2triple = new PropertyToTriple(graphSubjects);
        this.putPropertiesIntoContext();
    }

    private void putPropertiesIntoContext() throws RepositoryException {
        LOGGER.trace("Pushing RDF triples into context for properties of node: {}", (Object)this.node());
        if (this.node().hasProperties()) {
            this.concat(this.triplesFromProperties(this.node()));
        }
        javax.jcr.Node contentNode = null;
        try {
            if (this.node().hasNode("jcr:content")) {
                contentNode = this.node().getNode("jcr:content");
            }
        }
        catch (AccessControlException e) {
            LOGGER.trace("Access denied to content node", (Throwable)e);
        }
        if (contentNode != null) {
            final Node contentSubject = this.graphSubjects().getGraphSubject(contentNode).asNode();
            Node subject = this.graphSubjects().getGraphSubject(this.node()).asNode();
            this.concat(new Triple[]{Triple.create((Node)subject, (Node)RdfLexicon.HAS_CONTENT.asNode(), (Node)contentSubject), Triple.create((Node)contentSubject, (Node)RdfLexicon.IS_CONTENT_OF.asNode(), (Node)subject)});
            this.concat(new PropertiesRdfContext(this.node().getNode("jcr:content"), this.graphSubjects(), this.lowLevelStorageService()));
            this.lowLevelStorageService().setRepository(this.node().getSession().getRepository());
            this.concat(Iterators.transform(this.lowLevelStorageService().getLowLevelCacheEntries(contentNode).iterator(), (Function)new Function<LowLevelCacheEntry, Triple>(){

                public Triple apply(LowLevelCacheEntry llce) {
                    return Triple.create((Node)contentSubject, (Node)RdfLexicon.HAS_CONTENT_LOCATION.asNode(), (Node)ResourceFactory.createResource((String)llce.getExternalIdentifier()).asNode());
                }
            }));
        }
        if (this.node().getPrimaryNodeType().getName().equals("mode:root")) {
            this.concat(new RootRdfContext(this.node(), this.graphSubjects(), this.lowLevelStorageService()));
        }
    }

    private Iterator<Triple> triplesFromProperties(javax.jcr.Node n) throws RepositoryException {
        LOGGER.trace("Creating triples for node: {}", (Object)n);
        UnmodifiableIterator nonBinaryProperties = Iterators.filter((Iterator)((Object)new PropertyIterator(n.getProperties())), (Predicate)Predicates.not(FedoraTypesUtils.isBinaryContentProperty));
        UnmodifiableIterator nonBinaryPropertiesCopy = Iterators.filter((Iterator)((Object)new PropertyIterator(n.getProperties())), (Predicate)Predicates.not(FedoraTypesUtils.isBinaryContentProperty));
        return Iterators.concat(new ZippingIterator(Iterators.transform((Iterator)nonBinaryProperties, FedoraTypesUtils.property2values), Iterators.transform((Iterator)nonBinaryPropertiesCopy, (Function)this.property2triple)));
    }
}

