/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl.mappings;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.fcrepo.kernel.rdf.impl.mappings.ItemDefinitionToTriples;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyDefinitionToTriples
extends ItemDefinitionToTriples<PropertyDefinition> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyDefinitionToTriples.class);
    private static Node UNMAPPED_TYPE = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#UNMAPPED_TYPE");
    private static final Map<Integer, XSDDatatype> JCR_TYPE_TO_XSD_DATATYPE = ImmutableMap.builder().put((Object)6, (Object)XSDDatatype.XSDboolean).put((Object)5, (Object)XSDDatatype.XSDdate).put((Object)12, (Object)XSDDatatype.XSDdecimal).put((Object)4, (Object)XSDDatatype.XSDdecimal).put((Object)3, (Object)XSDDatatype.XSDlong).put((Object)11, (Object)XSDDatatype.XSDanyURI).put((Object)9, (Object)XSDDatatype.XSDanyURI).put((Object)10, (Object)XSDDatatype.XSDanyURI).put((Object)8, (Object)XSDDatatype.XSDanyURI).put((Object)2, (Object)XSDDatatype.XSDstring).put((Object)1, (Object)XSDDatatype.XSDstring).build();

    public PropertyDefinitionToTriples(Node domain) {
        super(domain);
    }

    @Override
    public Iterator<Triple> apply(PropertyDefinition input) {
        if (!input.getName().contains(":")) {
            LOGGER.debug("Received property definition with no namespace: {}", (Object)input.getName());
            LOGGER.debug("This cannot be serialized into several RDF formats, so we assume it is internal and discard it.");
            return Iterators.emptyIterator();
        }
        try {
            int requiredType = input.getRequiredType();
            Node rangeForJcrType = this.getRangeForJcrType(requiredType);
            if (rangeForJcrType != UNMAPPED_TYPE) {
                LOGGER.trace("Adding RDFS:range for property: {} with required type: {} as: {}", new Object[]{input.getName(), PropertyType.nameFromValue((int)requiredType), rangeForJcrType.getURI()});
                Triple propertyTriple = Triple.create((Node)PropertyDefinitionToTriples.getResource((ItemDefinition)input).asNode(), (Node)RDFS.range.asNode(), (Node)rangeForJcrType);
                return new RdfStream(propertyTriple).concat(super.apply(input));
            }
            LOGGER.trace("Skipping RDFS:range for property: {} with unmappable type: {}", (Object)input.getName(), (Object)PropertyType.nameFromValue((int)requiredType));
            return super.apply(input);
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Node getRangeForJcrType(int requiredType) {
        return JCR_TYPE_TO_XSD_DATATYPE.containsKey(requiredType) ? NodeFactory.createURI((String)JCR_TYPE_TO_XSD_DATATYPE.get(requiredType).getURI()) : UNMAPPED_TYPE;
    }
}

