/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.Datastream;
import org.fcrepo.kernel.exception.InvalidChecksumException;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.rdf.JcrRdfTools;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.fcrepo.kernel.services.RepositoryService;
import org.fcrepo.kernel.services.ServiceHelpers;
import org.fcrepo.kernel.services.policy.StoragePolicyDecisionPoint;
import org.fcrepo.kernel.utils.BinaryCacheEntry;
import org.fcrepo.kernel.utils.CacheEntry;
import org.fcrepo.kernel.utils.FixityResult;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.fcrepo.kernel.utils.ProjectedCacheEntry;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.fcrepo.metrics.RegistryService;
import org.modeshape.jcr.value.binary.ExternalBinaryValue;
import org.modeshape.jcr.value.binary.InMemoryBinaryValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DatastreamService
extends RepositoryService {
    @Autowired(required=false)
    StoragePolicyDecisionPoint storagePolicyDecisionPoint;
    @Autowired
    private LowLevelStorageService llStoreService;
    static final Counter fixityCheckCounter = RegistryService.getMetrics().counter(MetricRegistry.name(LowLevelStorageService.class, (String[])new String[]{"fixity-check-counter"}));
    static final Timer timer = RegistryService.getMetrics().timer(MetricRegistry.name(Datastream.class, (String[])new String[]{"fixity-check-time"}));
    static final Counter fixityRepairedCounter = RegistryService.getMetrics().counter(MetricRegistry.name(LowLevelStorageService.class, (String[])new String[]{"fixity-repaired-counter"}));
    static final Counter fixityErrorCounter = RegistryService.getMetrics().counter(MetricRegistry.name(LowLevelStorageService.class, (String[])new String[]{"fixity-error-counter"}));
    private static final Logger LOGGER = LoggerFactory.getLogger(DatastreamService.class);

    public Datastream createDatastream(Session session, String dsPath) throws RepositoryException {
        return new Datastream(session, dsPath);
    }

    public Node createDatastreamNode(Session session, String dsPath, String contentType, String originalFileName, InputStream requestBodyStream) throws RepositoryException, IOException, InvalidChecksumException {
        return this.createDatastreamNode(session, dsPath, contentType, originalFileName, requestBodyStream, null);
    }

    public Node createDatastreamNode(Session session, String dsPath, String contentType, String originalFileName, InputStream requestBodyStream, URI checksum) throws RepositoryException, IOException, InvalidChecksumException {
        Datastream ds = this.createDatastream(session, dsPath);
        ds.setContent(requestBodyStream, contentType, checksum, originalFileName, this.getStoragePolicyDecisionPoint());
        return ds.getNode();
    }

    public Node getDatastreamNode(Session session, String path) throws RepositoryException {
        LOGGER.trace("Executing getDatastreamNode() with path: {}", (Object)path);
        Node dsNode = this.getDatastream(session, path).getNode();
        LOGGER.trace("Retrieved datastream node: {}", (Object)dsNode.getName());
        return dsNode;
    }

    public Datastream getDatastream(Session session, String path) throws RepositoryException {
        return new Datastream(session, path);
    }

    public Datastream asDatastream(Node node) throws RepositoryException {
        return new Datastream(node);
    }

    public RdfStream getFixityResultsModel(GraphSubjects subjects, Datastream datastream) throws RepositoryException {
        Collection<FixityResult> blobs = this.runFixityAndFixProblems(datastream);
        return JcrRdfTools.withContext(subjects, datastream.getNode().getSession()).getJcrTriples(datastream.getNode(), blobs).topic(subjects.getGraphSubject(datastream.getNode()).asNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FixityResult> runFixityAndFixProblems(Datastream datastream) throws RepositoryException {
        ImmutableSet goodEntries;
        ImmutableSet fixityResults;
        final URI digestUri = datastream.getContentDigest();
        final long size = datastream.getContentSize();
        fixityCheckCounter.inc();
        Timer.Context context = timer.time();
        try {
            fixityResults = ImmutableSet.copyOf(this.getFixity(datastream.getNode().getNode("jcr:content"), digestUri, size));
            goodEntries = ImmutableSet.copyOf((Collection)Collections2.filter((Collection)fixityResults, (Predicate)new Predicate<FixityResult>(){

                public boolean apply(FixityResult input) {
                    return input.matches(size, digestUri);
                }
            }));
        }
        finally {
            context.stop();
        }
        if (goodEntries.isEmpty()) {
            LOGGER.error("ALL COPIES OF " + datastream.getNode().getPath() + " HAVE FAILED FIXITY CHECKS.");
            return fixityResults;
        }
        CacheEntry anyGoodCacheEntry = ((FixityResult)goodEntries.iterator().next()).getEntry();
        Sets.SetView badEntries = Sets.difference((Set)fixityResults, (Set)goodEntries);
        for (FixityResult result : badEntries) {
            try {
                LowLevelCacheEntry lle = (LowLevelCacheEntry)result.getEntry();
                lle.storeValue(anyGoodCacheEntry.getInputStream());
                FixityResult newResult = result.getEntry().checkFixity(digestUri, size);
                if (newResult.isSuccess()) {
                    result.setRepaired();
                    fixityRepairedCounter.inc();
                    continue;
                }
                fixityErrorCounter.inc();
            }
            catch (IOException e) {
                LOGGER.warn("Exception repairing low-level cache entry: {}", (Throwable)e);
            }
        }
        return fixityResults;
    }

    public Collection<FixityResult> getFixity(Node resource, URI dsChecksum, long dsSize) throws RepositoryException {
        LOGGER.debug("Checking resource: " + resource.getPath());
        Binary bin = resource.getProperty("jcr:data").getBinary();
        if (bin instanceof ExternalBinaryValue) {
            return ImmutableSet.of((Object)new ProjectedCacheEntry(bin, resource.getPath()).checkFixity(dsChecksum, dsSize));
        }
        if (bin instanceof InMemoryBinaryValue) {
            return ImmutableSet.of((Object)new BinaryCacheEntry(bin, resource.getPath()).checkFixity(dsChecksum, dsSize));
        }
        Function<LowLevelCacheEntry, FixityResult> checkCacheFunc = ServiceHelpers.getCheckCacheFixityFunction(dsChecksum, dsSize);
        return this.llStoreService.transformLowLevelCacheEntries(resource, checkCacheFunc);
    }

    public void setLlStoreService(LowLevelStorageService llStoreService) {
        this.llStoreService = llStoreService;
    }

    public void setStoragePolicyDecisionPoint(StoragePolicyDecisionPoint pdp) {
        this.storagePolicyDecisionPoint = pdp;
    }

    private StoragePolicyDecisionPoint getStoragePolicyDecisionPoint() {
        return this.storagePolicyDecisionPoint;
    }
}

