/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.fcrepo.jcr.FedoraJcrTypes;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.services.RepositoryService;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NodeService
extends RepositoryService
implements FedoraJcrTypes {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeService.class);

    public FedoraResource findOrCreateObject(Session session, String path) throws RepositoryException {
        return new FedoraResource(this.findOrCreateNode(session, path));
    }

    public FedoraResource getObject(Session session, String path) throws RepositoryException {
        return new FedoraResource(session.getNode(path));
    }

    public FedoraResource getObject(Session session, String path, String versionId) throws RepositoryException {
        VersionHistory versionHistory = FedoraTypesUtils.getVersionHistory(session, path);
        if (versionHistory == null) {
            return null;
        }
        if (!versionHistory.hasVersionLabel(versionId)) {
            return null;
        }
        Version version = versionHistory.getVersionByLabel(versionId);
        return new FedoraResource(version.getFrozenNode());
    }

    public Set<String> getObjectNames(Session session, String path) throws RepositoryException {
        return this.getObjectNames(session, path, null);
    }

    public Set<String> getObjectNames(Session session, String path, String mixin) throws RepositoryException {
        Node objects = session.getNode(path);
        ImmutableSet.Builder b = ImmutableSet.builder();
        NodeIterator i = objects.getNodes();
        while (i.hasNext()) {
            Node n = i.nextNode();
            LOGGER.trace("Child of type {} is named {} at {}", new Object[]{n.getPrimaryNodeType(), n.getName(), n.getPath()});
            if (mixin != null && !n.isNodeType(mixin)) continue;
            b.add((Object)n.getName());
        }
        return b.build();
    }

    public void deleteObject(Session session, String path) throws RepositoryException {
        Node obj = session.getNode(path);
        obj.remove();
    }

    public void copyObject(Session session, String source, String destination) throws RepositoryException {
        session.getWorkspace().copy(source, destination);
    }

    public void moveObject(Session session, String source, String destination) throws RepositoryException {
        session.getWorkspace().move(source, destination);
    }
}

