/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.TxSession;
import org.fcrepo.kernel.exception.TransactionMissingException;
import org.fcrepo.kernel.services.VersionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TransactionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionService.class);
    static final String FCREPO4_TX_ID = "fcrepo4.tx.id";
    @Autowired
    VersionService versionService;
    private static Map<String, Transaction> transactions = new ConcurrentHashMap<String, Transaction>();
    public static final long REAP_INTERVAL = 1000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRate=1000L)
    public void removeAndRollbackExpired() {
        Map<String, Transaction> map = transactions;
        synchronized (map) {
            Iterator<Map.Entry<String, Transaction>> txs = transactions.entrySet().iterator();
            while (txs.hasNext()) {
                Transaction tx = txs.next().getValue();
                if (tx.getExpires().getTime() > System.currentTimeMillis()) continue;
                try {
                    tx.rollback();
                }
                catch (RepositoryException e) {
                    LOGGER.error("Got exception rolling back expired transaction {}: {}", (Object)tx, (Object)e);
                }
                txs.remove();
            }
        }
    }

    public Transaction beginTransaction(Session sess) throws RepositoryException {
        Transaction tx = new Transaction(sess);
        String txId = tx.getId();
        transactions.put(txId, tx);
        sess.setNamespacePrefix(FCREPO4_TX_ID, txId);
        return tx;
    }

    public Transaction getTransaction(String txid) throws TransactionMissingException {
        Transaction tx = transactions.get(txid);
        if (tx == null) {
            throw new TransactionMissingException("Transaction is not available");
        }
        return tx;
    }

    public Transaction getTransaction(Session session) throws TransactionMissingException {
        String txId = TransactionService.getCurrentTransactionId(session);
        if (txId == null) {
            throw new TransactionMissingException("Transaction is not available");
        }
        return this.getTransaction(txId);
    }

    public static String getCurrentTransactionId(Session session) {
        try {
            if (session instanceof TxSession) {
                return ((TxSession)session).getTxId();
            }
            return session.getNamespaceURI(FCREPO4_TX_ID);
        }
        catch (RepositoryException e) {
            LOGGER.trace("Unable to retrieve current transaction ID from session", (Throwable)e);
            return null;
        }
    }

    public boolean exists(String txid) {
        return transactions.containsKey(txid);
    }

    public Transaction commit(String txid) throws RepositoryException {
        Transaction tx = transactions.remove(txid);
        if (tx == null) {
            throw new RepositoryException("Transaction with id " + txid + " is not available");
        }
        tx.commit(this.versionService);
        return tx;
    }

    public Transaction rollback(String txid) throws RepositoryException {
        Transaction tx = transactions.remove(txid);
        if (tx == null) {
            throw new RepositoryException("Transaction with id " + txid + " is not available");
        }
        tx.rollback();
        return tx;
    }
}

