/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import com.google.common.base.Preconditions;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.exception.TransactionMissingException;
import org.fcrepo.kernel.services.RepositoryService;
import org.fcrepo.kernel.services.TransactionService;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionService
extends RepositoryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionService.class);
    protected static final String VERSIONABLE = "mix:versionable";
    protected static final String VERSION_POLICY = "fedoraconfig:versioningPolicy";
    protected static final String AUTO_VERSION = "auto-version";
    @Autowired
    TransactionService txService;

    public void nodeUpdated(Session session, String absPath) throws RepositoryException {
        this.nodeUpdated(session.getNode(absPath));
    }

    public void nodeUpdated(Node n) throws RepositoryException {
        if (this.isVersioningEnabled(n) && this.isImplicitVersioningEnabled(n)) {
            this.queueOrCommitCheckpoint(n.getSession(), n.getPath());
        } else {
            LOGGER.trace("No implicit version checkpoint set for {}", (Object)n.getPath());
        }
    }

    public void createVersion(Workspace workspace, Collection<String> paths) throws RepositoryException {
        for (String absPath : paths) {
            this.checkpoint(workspace, absPath);
        }
    }

    private boolean isVersioningEnabled(Node n) throws RepositoryException {
        return n.isNodeType(VERSIONABLE);
    }

    private boolean isImplicitVersioningEnabled(Node n) throws RepositoryException {
        if (!n.hasProperty(VERSION_POLICY)) {
            return false;
        }
        Property p = n.getProperty(VERSION_POLICY);
        return FedoraTypesUtils.propertyContains(p, AUTO_VERSION);
    }

    private void queueOrCommitCheckpoint(Session session, String absPath) throws RepositoryException {
        String txId = TransactionService.getCurrentTransactionId(session);
        if (txId == null) {
            this.checkpoint(session.getWorkspace(), absPath);
        } else {
            this.queueCheckpoint(txId, absPath);
        }
    }

    private void checkpoint(Workspace workspace, String absPath) throws RepositoryException {
        LOGGER.trace("Setting implicit version checkpoint set for {}", (Object)absPath);
        workspace.getVersionManager().checkpoint(absPath);
    }

    private void queueCheckpoint(String txId, String absPath) throws TransactionMissingException {
        Transaction tx = this.txService.getTransaction(txId);
        LOGGER.trace("Queuing implicit version checkpoint set for {}", (Object)absPath);
        tx.addPathToVersion(absPath);
    }

    public void checkpoint(Node node) throws RepositoryException {
        Preconditions.checkNotNull((Object)node, (Object)"Cannot checkpoint null nodes");
        Session session = node.getSession();
        String absPath = node.getPath();
        if (node.isNodeType(VERSIONABLE)) {
            LOGGER.trace("Setting checkpoint for {}", (Object)absPath);
            String txId = TransactionService.getCurrentTransactionId(session);
            if (txId != null) {
                Transaction tx = this.txService.getTransaction(txId);
                tx.addPathToVersion(absPath);
            } else {
                session.getWorkspace().getVersionManager().checkpoint(absPath);
            }
        } else {
            LOGGER.trace("No checkpoint set for unversionable {}", (Object)absPath);
        }
    }
}

