/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services.functions;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;

public abstract class BooleanTypesPredicate
implements Predicate<Node> {
    protected final Collection<String> nodeTypes;

    public BooleanTypesPredicate(String ... types) {
        this.nodeTypes = Arrays.asList(types);
    }

    public boolean apply(Node input) {
        if (input == null) {
            throw new IllegalArgumentException("null node passed to" + this.getClass().getName());
        }
        int matched = 0;
        try {
            for (NodeType nodeType : input.getMixinNodeTypes()) {
                if (!this.nodeTypes.contains(nodeType.getName())) continue;
                ++matched;
            }
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this.test(matched);
    }

    protected abstract boolean test(int var1);
}

