/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.fcrepo.kernel.utils.CacheEntry;
import org.fcrepo.kernel.utils.ContentDigest;
import org.fcrepo.kernel.utils.FixityInputStream;
import org.fcrepo.kernel.utils.FixityResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicCacheEntry
implements CacheEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicCacheEntry.class);

    @Override
    public FixityResult checkFixity(URI checksum, long size) throws RepositoryException {
        FixityInputStream fixityInputStream;
        String digest = ContentDigest.getAlgorithm(checksum);
        try {
            fixityInputStream = new FixityInputStream(this.getInputStream(), MessageDigest.getInstance(digest));
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.warn("Could not create MessageDigest: {}", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        try {
            IOUtils.copy((InputStream)((Object)fixityInputStream), (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            URI calculatedChecksum = ContentDigest.asURI(digest, fixityInputStream.getMessageDigest().digest());
            FixityResult result = new FixityResult(this, fixityInputStream.getByteCount(), calculatedChecksum);
            if (checksum.equals(ContentDigest.missingChecksum()) || size == -1L) {
                result.status.add(FixityResult.FixityState.MISSING_STORED_FIXITY);
            }
            if (!result.matches(checksum)) {
                result.status.add(FixityResult.FixityState.BAD_CHECKSUM);
            }
            if (!result.matches(size)) {
                result.status.add(FixityResult.FixityState.BAD_SIZE);
            }
            if (result.matches(size, checksum)) {
                result.status.add(FixityResult.FixityState.SUCCESS);
            }
            LOGGER.debug("Got {}", (Object)result.toString());
            FixityResult fixityResult = result;
            return fixityResult;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            try {
                fixityInputStream.close();
            }
            catch (IOException e) {
                LOGGER.debug("Got error closing input stream: {}", (Throwable)e);
            }
        }
    }
}

