/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.Collection;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.fcrepo.jcr.FedoraJcrTypes;
import org.fcrepo.kernel.rdf.JcrRdfTools;
import org.fcrepo.kernel.services.functions.AnyTypesPredicate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.modeshape.jcr.api.Namespaced;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FedoraTypesUtils
implements FedoraJcrTypes {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraTypesUtils.class);
    public static Predicate<Node> isFedoraResource = new Predicate<Node>(){

        public boolean apply(Node node) {
            Preconditions.checkNotNull((Object)node, (Object)"null cannot be a Fedora object!");
            try {
                return FedoraTypesUtils.map(node.getMixinNodeTypes(), nodetype2name).contains("fedora:resource");
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Predicate<Node> isFrozen = new Predicate<Node>(){

        public boolean apply(Node node) {
            Preconditions.checkNotNull((Object)node, (Object)"null cannot be a Frozen node!");
            try {
                return node.getPrimaryNodeType().getName().equals("nt:frozenNode");
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Predicate<Node> isOrWasFedoraResource = new Predicate<Node>(){

        public boolean apply(Node node) {
            Preconditions.checkNotNull((Object)node, (Object)"null cannot be a Fedora object!");
            try {
                if (node.getPrimaryNodeType().getName().equals("nt:frozenNode")) {
                    PropertyIterator it = node.getProperties("jcr:frozenMixinTypes");
                    while (it.hasNext()) {
                        for (Value v : it.nextProperty().getValues()) {
                            if (!v.getString().equals("fedora:resource")) continue;
                            return true;
                        }
                    }
                    return false;
                }
                return FedoraTypesUtils.map(node.getMixinNodeTypes(), nodetype2name).contains("fedora:resource");
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Predicate<Node> isFedoraObject = new AnyTypesPredicate("fedora:object");
    public static Predicate<Node> isFedoraDatastream = new AnyTypesPredicate("fedora:datastream");
    public static Predicate<Node> isFedoraObjectOrDatastream = new AnyTypesPredicate("fedora:object", "fedora:datastream");
    public static Function<NodeType, String> nodetype2name = new Function<NodeType, String>(){

        public String apply(NodeType t) {
            Preconditions.checkNotNull((Object)t, (Object)"null has no name!");
            return t.getName();
        }
    };
    public static Function<Value, String> value2string = new Function<Value, String>(){

        public String apply(Value v) {
            try {
                Preconditions.checkNotNull((Object)v, (Object)"null has no appropriate String representation!");
                return v.getString();
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Function<Property, Iterator<Value>> property2values = new Function<Property, Iterator<Value>>(){

        public Iterator<Value> apply(Property p) {
            try {
                if (p.isMultiple()) {
                    LOGGER.debug("Found multi-valued property: {}", (Object)p);
                    return Iterators.forArray((Object[])p.getValues());
                }
                LOGGER.debug("Found single-valued property: {}", (Object)p);
                return Iterators.forArray((Object[])new Value[]{p.getValue()});
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Predicate<Property> isMultipleValuedProperty = new Predicate<Property>(){

        public boolean apply(Property p) {
            Preconditions.checkNotNull((Object)p, (Object)"null is neither multiple nor not multiple!");
            try {
                return p.isMultiple();
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Predicate<Property> isBinaryContentProperty = new Predicate<Property>(){

        public boolean apply(Property p) {
            Preconditions.checkNotNull((Object)p, (Object)"null is neither binary nor not binary!");
            try {
                return p.getType() == 2 && p.getName().equals("jcr:data");
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Predicate<Node> isInternalNode = new Predicate<Node>(){

        public boolean apply(Node n) {
            Preconditions.checkNotNull((Object)n, (Object)"null is neither internal nor not internal!");
            try {
                NodeType primaryNodeType = n.getPrimaryNodeType();
                return primaryNodeType != null && primaryNodeType.isNodeType("mode:system");
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Function<Property, com.hp.hpl.jena.rdf.model.Property> getPredicateForProperty = new Function<Property, com.hp.hpl.jena.rdf.model.Property>(){

        public com.hp.hpl.jena.rdf.model.Property apply(Property property) {
            LOGGER.trace("Creating predicate for property: {}", (Object)property);
            try {
                if (property instanceof Namespaced) {
                    Namespaced nsProperty = (Namespaced)property;
                    String uri = nsProperty.getNamespaceURI();
                    return ResourceFactory.createProperty((String)JcrRdfTools.getRDFNamespaceForJcrNamespace(uri), (String)nsProperty.getLocalName());
                }
                return ResourceFactory.createProperty((String)property.getName());
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    private static final DateTimeFormatter FMT = ISODateTimeFormat.dateTime();

    public static NodeTypeManager getNodeTypeManager(Node node) throws RepositoryException {
        return node.getSession().getWorkspace().getNodeTypeManager();
    }

    public static PropertyDefinition getDefinitionForPropertyName(Node node, String propertyName) throws RepositoryException {
        PropertyDefinition[] propertyDefinitions = node.getPrimaryNodeType().getPropertyDefinitions();
        LOGGER.debug("Looking for property name: {}", (Object)propertyName);
        for (PropertyDefinition propertyDefinition : propertyDefinitions) {
            LOGGER.debug("Checking property: {}", (Object)propertyDefinition.getName());
            if (!propertyDefinition.getName().equals(propertyName)) continue;
            return propertyDefinition;
        }
        for (PropertyDefinition propertyDefinition : node.getMixinNodeTypes()) {
            for (PropertyDefinition p : propertyDefinition.getPropertyDefinitions()) {
                if (!p.getName().equals(propertyName)) continue;
                return p;
            }
        }
        return null;
    }

    public static <F, T> Collection<T> map(F[] input, Function<F, T> f) {
        return Collections2.transform((Collection)ImmutableSet.copyOf((Object[])input), f);
    }

    public static String convertDateToXSDString(long date) {
        DateTime dt = new DateTime(date, DateTimeZone.UTC);
        return FMT.print((ReadableInstant)dt);
    }

    public static Version getBaseVersion(Node node) throws RepositoryException {
        return node.getSession().getWorkspace().getVersionManager().getBaseVersion(node.getPath());
    }

    public static VersionHistory getVersionHistory(Node node) throws RepositoryException {
        return FedoraTypesUtils.getVersionHistory(node.getSession(), node.getPath());
    }

    public static VersionHistory getVersionHistory(Session session, String path) throws RepositoryException {
        return session.getWorkspace().getVersionManager().getVersionHistory(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRepositoryCount(Repository repository) throws RepositoryException {
        Session session = repository.login();
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String querystring = "SELECT [jcr:path] FROM [fedora:object]";
            QueryResult queryResults = queryManager.createQuery("SELECT [jcr:path] FROM [fedora:object]", "JCR-SQL2").execute();
            long l = queryResults.getRows().getSize();
            return l;
        }
        finally {
            session.logout();
        }
    }

    public static long getRepositorySize(Repository repository) throws RepositoryException {
        Session session = repository.login();
        long sum = 0L;
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        String querystring = "SELECT [premis:hasSize] FROM [fedora:binary]";
        QueryResult queryResults = queryManager.createQuery("SELECT [premis:hasSize] FROM [fedora:binary]", "JCR-SQL2").execute();
        RowIterator rows = queryResults.getRows();
        while (rows.hasNext()) {
            Value value = rows.nextRow().getValue("premis:hasSize");
            sum += value.getLong();
        }
        session.logout();
        return sum;
    }

    public static boolean propertyContains(Property p, String value) throws RepositoryException {
        if (p == null) {
            return false;
        }
        if (p.isMultiple()) {
            return Iterators.contains((Iterator)Iterators.transform((Iterator)Iterators.forArray((Object[])p.getValues()), value2string), (Object)value);
        }
        return value.equals(p.getString());
    }
}

