/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import java.net.URI;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.utils.CacheEntry;

public class FixityResult {
    public Set<FixityState> status = EnumSet.noneOf(FixityState.class);
    public long computedSize;
    public URI computedChecksum;
    private final CacheEntry entry;

    public FixityResult() {
        this(null);
    }

    public FixityResult(CacheEntry entry) {
        this.entry = entry;
    }

    public FixityResult(long size, URI checksum) {
        this(null, size, checksum);
    }

    public FixityResult(CacheEntry entry, long size, URI checksum) {
        this.entry = entry;
        this.computedSize = size;
        this.computedChecksum = checksum;
    }

    public String getStoreIdentifier() throws RepositoryException {
        return this.entry.getExternalIdentifier();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof FixityResult) {
            FixityResult that = (FixityResult)obj;
            result = this.computedSize == that.computedSize && this.computedChecksum.equals(that.computedChecksum);
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.computedSize, this.computedChecksum);
    }

    public String toString() {
        return "Fixity: checksum: " + this.computedChecksum + " / " + Long.toString(this.computedSize);
    }

    public CacheEntry getEntry() {
        return this.entry;
    }

    public boolean matches(URI checksum) {
        return this.computedChecksum.equals(checksum);
    }

    public boolean matches(long size) {
        return this.computedSize == size;
    }

    public boolean matches(long size, URI checksum) {
        return this.matches(size) && this.matches(checksum);
    }

    public boolean isSuccess() {
        return this.status.contains((Object)FixityState.SUCCESS);
    }

    public void setRepaired() {
        this.status.add(FixityState.REPAIRED);
    }

    public static enum FixityState {
        SUCCESS,
        REPAIRED,
        BAD_CHECKSUM,
        BAD_SIZE,
        MISSING_STORED_FIXITY;

    }
}

