/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import com.google.common.base.Throwables;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Statement;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.RdfLexicon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceChangedStatementListener
extends StatementListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceChangedStatementListener.class);
    private final NamespaceRegistry namespaceRegistry;

    public NamespaceChangedStatementListener(Session session) throws RepositoryException {
        this.namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
    }

    public void addedStatement(Statement s) {
        LOGGER.debug(">> added statement {}", (Object)s);
        if (!s.getPredicate().equals(RdfLexicon.HAS_NAMESPACE_PREFIX)) {
            return;
        }
        try {
            String prefix = s.getObject().asLiteral().getString();
            String uri = s.getSubject().asResource().getURI();
            LOGGER.debug("Registering namespace prefix {} for uri {}", (Object)prefix, (Object)uri);
            this.namespaceRegistry.registerNamespace(prefix, uri);
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void removedStatement(Statement s) {
        LOGGER.debug(">> removed statement {}", (Object)s);
        if (!s.getPredicate().equals(RdfLexicon.HAS_NAMESPACE_PREFIX)) {
            return;
        }
        try {
            String prefix = s.getObject().asLiteral().getString();
            String uri = s.getSubject().asResource().getURI();
            if (this.namespaceRegistry.getPrefix(uri).equals(prefix)) {
                LOGGER.debug("De-registering namespace prefix {} for uri {}", (Object)prefix, (Object)uri);
                this.namespaceRegistry.unregisterNamespace(prefix);
            }
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

