/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.UUID;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.SelfClosingInputStream;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.NodeKeyReference;
import org.modeshape.jcr.value.basic.UuidReference;

@NotThreadSafe
final class JcrSingleValueProperty
extends AbstractJcrProperty {
    JcrSingleValueProperty(AbstractJcrNode node, Name name, int propertyType) {
        super(node, name, propertyType);
    }

    public boolean isMultiple() {
        return false;
    }

    public boolean getBoolean() throws RepositoryException {
        this.checkSession();
        try {
            return (Boolean)this.context().getValueFactories().getBooleanFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
    }

    public Calendar getDate() throws RepositoryException {
        this.checkSession();
        try {
            return ((DateTime)this.context().getValueFactories().getDateFactory().create(this.property().getFirstValue())).toCalendar();
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
    }

    public double getDouble() throws RepositoryException {
        this.checkSession();
        try {
            return (Double)this.context().getValueFactories().getDoubleFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
    }

    public BigDecimal getDecimal() throws javax.jcr.ValueFormatException, RepositoryException {
        this.checkSession();
        try {
            return (BigDecimal)this.context().getValueFactories().getDecimalFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
    }

    public long getLength() throws RepositoryException {
        this.checkSession();
        return this.createValue(this.property().getFirstValue()).getLength();
    }

    public long[] getLengths() throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForSingleValuedProperty.text(new Object[0]));
    }

    public long getLong() throws RepositoryException {
        this.checkSession();
        try {
            return (Long)this.context().getValueFactories().getLongFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
    }

    public final Node getNode() throws ItemNotFoundException, javax.jcr.ValueFormatException, RepositoryException {
        this.checkSession();
        ValueFactories factories = this.context().getValueFactories();
        Object value = this.property().getFirstValue();
        try {
            if (value instanceof Reference) {
                NodeKey key = null;
                if (value instanceof NodeKeyReference) {
                    key = ((NodeKeyReference)value).getNodeKey();
                } else if (value instanceof UuidReference) {
                    UUID uuid = ((UuidReference)value).getUuid();
                    key = this.getParent().key().withId(uuid.toString());
                } else assert (false) : "Unknown type of Reference value";
                return this.session().node(key, null);
            }
            Path path = (Path)factories.getPathFactory().create(value);
            return path.isAbsolute() ? this.session().node(path) : this.session().node(this.getParent().node(), path);
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
        catch (PathNotFoundException pathNotFound) {
            throw new ItemNotFoundException(pathNotFound.getMessage(), (Throwable)pathNotFound);
        }
    }

    public AbstractJcrProperty getProperty() throws ItemNotFoundException, javax.jcr.ValueFormatException, RepositoryException {
        this.checkSession();
        Path path = null;
        try {
            path = (Path)this.session().pathFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
        AbstractJcrNode referencedNode = null;
        try {
            referencedNode = path.isAbsolute() ? this.session().node(path) : this.session().node(this.cachedNode(), path);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage(), (Throwable)e);
        }
        Name propertyName = path.getLastSegment().getName();
        if (!referencedNode.hasProperty(propertyName)) {
            String readablePath = path.getString(this.namespaces());
            String workspaceName = this.session().workspaceName();
            String msg = null;
            msg = path.isAbsolute() ? JcrI18n.pathNotFound.text(new Object[]{readablePath, workspaceName}) : JcrI18n.pathNotFoundRelativeTo.text(new Object[]{readablePath, this.getParent().getPath(), workspaceName});
            throw new PathNotFoundException(msg);
        }
        return referencedNode.getProperty(propertyName);
    }

    public InputStream getStream() throws RepositoryException {
        this.checkSession();
        try {
            BinaryValue binary = (BinaryValue)this.context().getValueFactories().getBinaryFactory().create(this.property().getFirstValue());
            return new SelfClosingInputStream(binary);
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
    }

    public Binary getBinary() throws javax.jcr.ValueFormatException, RepositoryException {
        this.checkSession();
        try {
            return (Binary)this.context().getValueFactories().getBinaryFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
    }

    public String getString() throws RepositoryException {
        this.checkSession();
        try {
            return (String)this.context().getValueFactories().getStringFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public JcrValue getValue() throws RepositoryException {
        this.checkSession();
        return this.createValue(this.property().getFirstValue());
    }

    public void setValue(Value value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        JcrValue jcrValue = null;
        if (value == null) {
            this.mutable().removeProperty(this.sessionCache(), this.name());
            return;
        }
        if (value instanceof JcrValue) {
            jcrValue = (JcrValue)value;
            if (jcrValue.value() == null) {
                throw new javax.jcr.ValueFormatException(JcrI18n.valueMayNotContainNull.text(new Object[]{this.getName()}));
            }
            Object literal = jcrValue.asType(this.getType()).value();
            Property newProp = this.session().propertyFactory().create(this.name(), literal);
            this.mutable().setProperty(this.sessionCache(), newProp);
            return;
        }
        switch (value.getType()) {
            case 1: {
                this.setValue(value.getString());
                break;
            }
            case 2: {
                this.setValue(value.getBinary());
                break;
            }
            case 6: {
                this.setValue(value.getBoolean());
                break;
            }
            case 5: {
                this.setValue(value.getDate());
                break;
            }
            case 4: {
                this.setValue(value.getDouble());
                break;
            }
            case 12: {
                this.setValue(value.getDecimal());
                break;
            }
            case 3: {
                this.setValue(value.getLong());
                break;
            }
            case 7: {
                this.setValue(value.getString());
                break;
            }
            case 8: {
                this.setValue(value.getString());
                break;
            }
            case 9: 
            case 10: 
            case 100: {
                this.setValue(value.getString());
                break;
            }
            default: {
                throw new RepositoryException(JcrI18n.invalidPropertyType.text(new Object[]{value.getType()}));
            }
        }
    }

    protected void internalSetValue(JcrValue jcrValue) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        assert (jcrValue != null);
        if (jcrValue.value() == null) {
            throw new javax.jcr.ValueFormatException(JcrI18n.valueMayNotContainNull.text(new Object[]{this.getName()}));
        }
        if (this.session.cache().isReadOnly()) {
            throw new AccessDeniedException();
        }
        Object literal = jcrValue.asType(this.getType()).value();
        Property newProp = this.session().propertyFactory().create(this.name(), literal);
        this.mutable().setProperty(this.sessionCache(), newProp);
    }

    public void setValue(String value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        this.internalSetValue(this.createValue(value, 1).asType(this.getType()));
    }

    public void setValue(InputStream value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        this.internalSetValue(this.createValue(this.context().getValueFactories().getBinaryFactory().create(value), 2).asType(this.getType()));
    }

    public void setValue(long value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        this.internalSetValue(this.createValue(value, 3).asType(this.getType()));
    }

    public void setValue(double value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        this.internalSetValue(this.createValue(value, 4).asType(this.getType()));
    }

    public void setValue(Calendar value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        this.internalSetValue(this.createValue(this.context().getValueFactories().getDateFactory().create(value), 5).asType(this.getType()));
    }

    public void setValue(boolean value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        this.internalSetValue(this.createValue(value, 6).asType(this.getType()));
    }

    public void setValue(Node value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        if (!value.isNodeType(JcrMixLexicon.REFERENCEABLE.getString(this.context().getNamespaceRegistry()))) {
            throw new javax.jcr.ValueFormatException(JcrI18n.nodeNotReferenceable.text(new Object[0]));
        }
        AbstractJcrNode jcrNode = this.session.getNodeByIdentifier(value.getIdentifier());
        if (!jcrNode.isInTheSameProcessAs(this.session.context().getProcessId())) {
            throw new RepositoryException(JcrI18n.nodeNotInTheSameSession.text(new Object[]{jcrNode.path()}));
        }
        JcrValue referenceValue = this.session().valueFactory().createValue(jcrNode);
        this.internalSetValue(referenceValue.asType(this.getType()));
    }

    public void setValue(Binary value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        BinaryValue binary = null;
        binary = value instanceof BinaryValue ? (BinaryValue)value : (BinaryValue)this.context().getValueFactories().getBinaryFactory().create(value.getStream());
        this.internalSetValue(this.createValue(binary, 2).asType(this.getType()));
    }

    public void setValue(BigDecimal value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        this.internalSetValue(this.createValue(value, 12).asType(this.getType()));
    }

    @Override
    public JcrValue[] getValues() throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForSingleValuedProperty.text(new Object[0]));
    }

    public void setValue(Value[] values) throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForSingleValuedProperty.text(new Object[0]));
    }

    public void setValue(String[] values) throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForSingleValuedProperty.text(new Object[0]));
    }
}

