/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.apache.tika.io.IOUtils;
import org.fcrepo.jcr.FedoraJcrTypes;
import org.fcrepo.kernel.Datastream;
import org.fcrepo.kernel.DatastreamImpl;
import org.fcrepo.kernel.FedoraObject;
import org.fcrepo.kernel.exception.InvalidChecksumException;
import org.fcrepo.kernel.utils.TestHelpers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.ValueFactory;

public class DatastreamTest
implements FedoraJcrTypes {
    private static final String testDsId = "testDs";
    Datastream testObj;
    @Mock
    Session mockSession;
    @Mock
    Node mockRootNode;
    @Mock
    Node mockDsNode;
    @Mock
    ValueFactory mockVF;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        NodeType[] nodeTypes = new NodeType[]{};
        try {
            Mockito.when((Object)this.mockDsNode.getMixinNodeTypes()).thenReturn((Object)nodeTypes);
            Mockito.when((Object)this.mockDsNode.getName()).thenReturn((Object)testDsId);
            Mockito.when((Object)this.mockDsNode.getSession()).thenReturn((Object)this.mockSession);
            NodeType mockNodeType = (NodeType)Mockito.mock(NodeType.class);
            Mockito.when((Object)mockNodeType.getName()).thenReturn((Object)"nt:file");
            Mockito.when((Object)this.mockDsNode.getPrimaryNodeType()).thenReturn((Object)mockNodeType);
            this.testObj = new DatastreamImpl(this.mockDsNode);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        this.mockSession = null;
        this.mockRootNode = null;
        this.mockDsNode = null;
    }

    @Test
    public void testGetNode() {
        Assert.assertEquals((Object)this.testObj.getNode(), (Object)this.mockDsNode);
    }

    @Test
    public void testGetContent() throws RepositoryException, IOException {
        String expected = "asdf";
        Node mockContent = TestHelpers.getContentNodeMock("asdf");
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)mockContent);
        String actual = IOUtils.toString((InputStream)this.testObj.getContent());
        Assert.assertEquals((Object)"asdf", (Object)actual);
        ((Node)Mockito.verify((Object)mockContent)).getProperty("jcr:data");
    }

    @Test
    public void testSetContent() throws RepositoryException, InvalidChecksumException {
        Binary mockBin = (Binary)Mockito.mock(Binary.class);
        InputStream mockStream = (InputStream)Mockito.mock(InputStream.class);
        Node mockContent = TestHelpers.getContentNodeMock(8);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)mockContent);
        Mockito.when((Object)this.mockDsNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)this.mockVF);
        Mockito.when((Object)this.mockVF.createBinary((InputStream)Matchers.any(InputStream.class), (String)Matchers.any(String.class))).thenReturn((Object)mockBin);
        Property mockData = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockContent.canAddMixin("fedora:binary")).thenReturn((Object)true);
        Mockito.when((Object)mockContent.setProperty("jcr:data", (javax.jcr.Binary)mockBin)).thenReturn((Object)mockData);
        Mockito.when((Object)mockContent.getProperty("jcr:data")).thenReturn((Object)mockData);
        Mockito.when((Object)mockData.getBinary()).thenReturn((Object)mockBin);
        this.testObj.setContent(mockStream);
    }

    @Test
    public void testSetContentWithFilename() throws RepositoryException, InvalidChecksumException {
        Binary mockBin = (Binary)Mockito.mock(Binary.class);
        InputStream mockStream = (InputStream)Mockito.mock(InputStream.class);
        Node mockContent = TestHelpers.getContentNodeMock(8);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)mockContent);
        Mockito.when((Object)this.mockDsNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)this.mockVF);
        Mockito.when((Object)this.mockVF.createBinary((InputStream)Matchers.any(InputStream.class), (String)Matchers.any(String.class))).thenReturn((Object)mockBin);
        Property mockData = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockContent.canAddMixin("fedora:binary")).thenReturn((Object)true);
        Mockito.when((Object)mockContent.setProperty("jcr:data", (javax.jcr.Binary)mockBin)).thenReturn((Object)mockData);
        Mockito.when((Object)mockContent.getProperty("jcr:data")).thenReturn((Object)mockData);
        Mockito.when((Object)mockData.getBinary()).thenReturn((Object)mockBin);
        this.testObj.setContent(mockStream, null, null, "xyz", null);
        ((Node)Mockito.verify((Object)mockContent)).setProperty("premis:hasOriginalName", "xyz");
    }

    @Test(expected=InvalidChecksumException.class)
    public void testSetContentWithChecksumMismatch() throws RepositoryException, InvalidChecksumException, URISyntaxException {
        Binary mockBin = (Binary)Mockito.mock(Binary.class);
        InputStream mockStream = (InputStream)Mockito.mock(InputStream.class);
        Node mockContent = TestHelpers.getContentNodeMock(8);
        Mockito.when((Object)this.mockDsNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)mockContent);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)this.mockVF);
        Mockito.when((Object)this.mockVF.createBinary((InputStream)Matchers.any(InputStream.class), (String)Matchers.any(String.class))).thenReturn((Object)mockBin);
        Property mockData = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockContent.canAddMixin("fedora:binary")).thenReturn((Object)true);
        Mockito.when((Object)mockContent.setProperty("jcr:data", (javax.jcr.Binary)mockBin)).thenReturn((Object)mockData);
        Mockito.when((Object)mockContent.getProperty("jcr:data")).thenReturn((Object)mockData);
        Mockito.when((Object)mockData.getBinary()).thenReturn((Object)mockBin);
        this.testObj.setContent(mockStream, null, new URI("urn:sha1:xyz"), null, null);
    }

    @Test
    public void getContentSize() throws RepositoryException {
        int expectedContentLength = 2;
        Node mockContent = TestHelpers.getContentNodeMock(2);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)mockContent);
        long actual = this.testObj.getContentSize();
        ((Node)Mockito.verify((Object)mockContent)).getProperty("premis:hasSize");
        Assert.assertEquals((long)2L, (long)actual);
    }

    @Test
    public void getContentDigest() throws RepositoryException {
        String content = "asdf";
        URI expected = URI.create(TestHelpers.checksumString("asdf"));
        Node mockContent = TestHelpers.getContentNodeMock("asdf");
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)mockContent);
        URI actual = this.testObj.getContentDigest();
        Assert.assertEquals((Object)expected, (Object)actual);
        ((Node)Mockito.verify((Object)mockContent)).getProperty("fedora:digest");
    }

    @Test
    public void testGetDsId() throws RepositoryException {
        String actual = this.testObj.getDsId();
        Assert.assertEquals((Object)testDsId, (Object)actual);
    }

    @Test
    public void testGetObject() throws RepositoryException {
        Node mockObjectNode = (Node)Mockito.mock(Node.class);
        NodeType mockNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockNodeType.getName()).thenReturn((Object)"fedora:object");
        Mockito.when((Object)mockObjectNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{mockNodeType});
        NodeType mockPrimaryNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockPrimaryNodeType.getName()).thenReturn((Object)"nt:file");
        Mockito.when((Object)mockObjectNode.getPrimaryNodeType()).thenReturn((Object)mockPrimaryNodeType);
        Mockito.when((Object)this.mockDsNode.getParent()).thenReturn((Object)mockObjectNode);
        FedoraObject actual = this.testObj.getObject();
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)mockObjectNode, (Object)actual.getNode());
    }

    @Test
    public void testGetMimeType() throws RepositoryException {
        Node mockContent = TestHelpers.getContentNodeMock(8);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)mockContent);
        Mockito.when((Object)this.mockDsNode.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)mockContent.hasProperty("jcr:mimeType")).thenReturn((Object)true);
        Property mockProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockContent.getProperty("jcr:mimeType")).thenReturn((Object)mockProperty);
        Mockito.when((Object)mockProperty.getString()).thenReturn((Object)"application/x-mime-type");
        Assert.assertEquals((Object)"application/x-mime-type", (Object)this.testObj.getMimeType());
    }

    @Test
    public void testGetMimeTypeWithNoContent() throws RepositoryException {
        Mockito.when((Object)this.mockDsNode.hasNode("jcr:content")).thenReturn((Object)false);
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.testObj.getMimeType());
    }

    @Test
    public void testGetMimeTypeWithDefault() throws RepositoryException {
        Node mockContent = TestHelpers.getContentNodeMock(8);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)mockContent);
        Mockito.when((Object)this.mockDsNode.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)mockContent.hasProperty("jcr:mimeType")).thenReturn((Object)false);
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.testObj.getMimeType());
    }

    @Test
    public void testGetCreatedDate() throws RepositoryException {
        Date expected = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(expected);
        Property mockProp = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockProp.getDate()).thenReturn((Object)cal);
        Mockito.when((Object)this.mockDsNode.hasProperty("jcr:created")).thenReturn((Object)true);
        Mockito.when((Object)this.mockDsNode.getProperty("jcr:created")).thenReturn((Object)mockProp);
        Date actual = this.testObj.getCreatedDate();
        Assert.assertEquals((long)expected.getTime(), (long)actual.getTime());
    }

    @Test
    public void testGetLastModifiedDate() throws RepositoryException {
        Date expected = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(expected);
        Property mockProp = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockProp.getDate()).thenReturn((Object)cal);
        Mockito.when((Object)this.mockDsNode.hasProperty("jcr:lastModified")).thenReturn((Object)true);
        Mockito.when((Object)this.mockDsNode.getProperty("jcr:lastModified")).thenReturn((Object)mockProp);
        Date actual = this.testObj.getLastModifiedDate();
        Assert.assertEquals((long)expected.getTime(), (long)actual.getTime());
    }

    @Test
    public void testGetSize() throws RepositoryException {
        boolean expectedProps = true;
        int expectedContentLength = 2;
        Node mockContent = TestHelpers.getContentNodeMock(2);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)mockContent);
        Mockito.when((Object)this.mockDsNode.getProperties()).thenAnswer((Answer)new Answer<PropertyIterator>(){

            public PropertyIterator answer(InvocationOnMock invocation) {
                return TestHelpers.getPropertyIterator(1, 1L);
            }
        });
        long actual = this.testObj.getSize();
        ((Node)Mockito.verify((Object)this.mockDsNode, (VerificationMode)Mockito.times((int)1))).getProperties();
        Assert.assertEquals((long)3L, (long)actual);
    }

    @Test
    public void testHasMixin() throws RepositoryException {
        NodeType mockYes = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockYes.getName()).thenReturn((Object)"fedora:datastream");
        NodeType mockNo = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockNo.getName()).thenReturn((Object)"notfedora:datastream");
        NodeType[] types = new NodeType[]{mockYes};
        Node test = (Node)Mockito.mock(Node.class);
        NodeType mockPrimaryNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockPrimaryNodeType.getName()).thenReturn((Object)"nt:object");
        Mockito.when((Object)test.getPrimaryNodeType()).thenReturn((Object)mockPrimaryNodeType);
        Mockito.when((Object)test.getMixinNodeTypes()).thenReturn((Object)types);
        Assert.assertEquals((Object)true, (Object)DatastreamImpl.hasMixin((Node)test));
        types[0] = mockNo;
        Assert.assertEquals((Object)false, (Object)DatastreamImpl.hasMixin((Node)test));
    }
}

