/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.commons.codec.digest.DigestUtils;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.FedoraResourceImpl;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.rdf.JcrRdfTools;
import org.fcrepo.kernel.rdf.impl.DefaultGraphSubjects;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "org.apache.xerces.*", "javax.xml.*", "org.xml.sax.*", "javax.management.*", "com.google.common.*", "com.hp.hpl.jena.*", "com.codahale.metrics.*"})
@PrepareForTest(value={JcrRdfTools.class, FedoraTypesUtils.class})
public class FedoraResourceImplTest {
    private FedoraResource testObj;
    @Mock
    private javax.jcr.Node mockNode;
    @Mock
    private javax.jcr.Node mockRoot;
    @Mock
    private Session mockSession;
    private Resource mockResource = ResourceFactory.createResource();
    @Mock
    private Property mockProp;
    private Triple mockTriple = Triple.create((Node)NodeFactory.createAnon(), (Node)NodeFactory.createAnon(), (Node)NodeFactory.createAnon());
    @Mock
    private JcrRdfTools mockJcrRdfTools;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        NodeType mockNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockNodeType.getName()).thenReturn((Object)"nt:folder");
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)mockNodeType);
        this.testObj = new FedoraResourceImpl(this.mockNode);
        Assert.assertEquals((Object)this.mockNode, (Object)this.testObj.getNode());
    }

    @Test
    public void testPathConstructor() throws RepositoryException {
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockRoot.getNode("foo/bar")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.isNew()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        new FedoraResourceImpl(this.mockSession, "/foo/bar", null);
    }

    @Test
    public void testHasMixin() throws RepositoryException {
        NodeType mockType = (NodeType)Mockito.mock(NodeType.class);
        NodeType[] mockTypes = new NodeType[]{mockType};
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)mockTypes);
        boolean actual = FedoraTypesUtils.isFedoraResource.apply((Object)this.mockNode);
        Assert.assertEquals((Object)false, (Object)actual);
        Mockito.when((Object)mockType.getName()).thenReturn((Object)"fedora:resource");
        actual = FedoraTypesUtils.isFedoraResource.apply((Object)this.mockNode);
        Assert.assertEquals((Object)true, (Object)actual);
    }

    @Test
    public void testGetPath() throws RepositoryException {
        this.testObj.getPath();
        ((javax.jcr.Node)Mockito.verify((Object)this.mockNode)).getPath();
    }

    @Test
    public void testHasContent() throws RepositoryException {
        this.testObj.hasContent();
        ((javax.jcr.Node)Mockito.verify((Object)this.mockNode)).hasNode("jcr:content");
    }

    @Test
    public void testGetCreatedDate() throws RepositoryException {
        Calendar someDate = Calendar.getInstance();
        Mockito.when((Object)this.mockProp.getDate()).thenReturn((Object)someDate);
        Mockito.when((Object)this.mockNode.hasProperty("jcr:created")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getProperty("jcr:created")).thenReturn((Object)this.mockProp);
        Assert.assertEquals((long)someDate.getTimeInMillis(), (long)this.testObj.getCreatedDate().getTime());
    }

    @Test
    public void testGetLastModifiedDateDefault() throws RepositoryException {
        Calendar someDate = Calendar.getInstance();
        someDate.add(5, -1);
        try {
            Mockito.when((Object)this.mockNode.hasProperty("jcr:lastModified")).thenReturn((Object)false);
            Mockito.when((Object)this.mockProp.getDate()).thenReturn((Object)someDate);
            Mockito.when((Object)this.mockNode.hasProperty("jcr:created")).thenReturn((Object)true);
            Mockito.when((Object)this.mockNode.getProperty("jcr:created")).thenReturn((Object)this.mockProp);
            Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        Date actual = this.testObj.getLastModifiedDate();
        Assert.assertEquals((long)someDate.getTimeInMillis(), (long)actual.getTime());
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).save();
    }

    @Test
    public void testGetLastModifiedDate() throws RepositoryException {
        Calendar someDate = Calendar.getInstance();
        someDate.add(5, -1);
        try {
            Mockito.when((Object)this.mockProp.getDate()).thenReturn((Object)someDate);
            Mockito.when((Object)this.mockNode.hasProperty("jcr:created")).thenReturn((Object)true);
            Mockito.when((Object)this.mockNode.getProperty("jcr:created")).thenReturn((Object)this.mockProp);
            Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        Property mockMod = (Property)Mockito.mock(Property.class);
        Calendar modDate = Calendar.getInstance();
        try {
            Mockito.when((Object)this.mockNode.hasProperty("jcr:lastModified")).thenReturn((Object)true);
            Mockito.when((Object)this.mockNode.getProperty("jcr:lastModified")).thenReturn((Object)mockMod);
            Mockito.when((Object)mockMod.getDate()).thenReturn((Object)modDate);
        }
        catch (RepositoryException e) {
            System.err.println("What are we doing in the second test?");
            e.printStackTrace();
        }
        Date actual = this.testObj.getLastModifiedDate();
        Assert.assertEquals((long)modDate.getTimeInMillis(), (long)actual.getTime());
    }

    @Test
    public void testGetPropertiesDataset() throws Exception {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        GraphSubjects mockSubjects = (GraphSubjects)Mockito.mock(GraphSubjects.class);
        Mockito.when((Object)JcrRdfTools.withContext((GraphSubjects)mockSubjects, (Session)this.mockSession)).thenReturn((Object)this.mockJcrRdfTools);
        Mockito.when((Object)mockSubjects.getGraphSubject(this.mockNode)).thenReturn((Object)this.mockResource);
        RdfStream propertiesStream = new RdfStream(this.mockTriple);
        Mockito.when((Object)this.mockJcrRdfTools.getJcrTriples(this.mockNode)).thenReturn((Object)propertiesStream);
        RdfStream treeStream = new RdfStream(this.mockTriple);
        Mockito.when((Object)this.mockJcrRdfTools.getTreeTriples(this.mockNode)).thenReturn((Object)treeStream);
        Model problemsModel = new RdfStream().asModel();
        Mockito.when((Object)JcrRdfTools.getProblemsModel()).thenReturn((Object)problemsModel);
        Dataset dataset = this.testObj.getPropertiesDataset(mockSubjects, 0, -1);
        Assert.assertTrue((boolean)dataset.getDefaultModel().containsAll(propertiesStream.asModel()));
        Assert.assertTrue((boolean)dataset.getDefaultModel().containsAll(propertiesStream.asModel()));
        Assert.assertEquals((Object)this.mockResource, (Object)dataset.getContext().get(Symbol.create((String)"uri")));
    }

    @Test
    public void testGetPropertiesDatasetDefaultLimits() throws Exception {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        GraphSubjects mockSubjects = (GraphSubjects)Mockito.mock(GraphSubjects.class);
        Mockito.when((Object)JcrRdfTools.withContext((GraphSubjects)mockSubjects, (Session)this.mockSession)).thenReturn((Object)this.mockJcrRdfTools);
        Mockito.when((Object)mockSubjects.getGraphSubject(this.mockNode)).thenReturn((Object)this.mockResource);
        RdfStream propertiesStream = new RdfStream(this.mockTriple);
        Mockito.when((Object)this.mockJcrRdfTools.getJcrTriples(this.mockNode)).thenReturn((Object)propertiesStream);
        RdfStream treeStream = new RdfStream(this.mockTriple);
        Mockito.when((Object)this.mockJcrRdfTools.getTreeTriples(this.mockNode)).thenReturn((Object)treeStream);
        Model problemsModel = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getProblemsModel()).thenReturn((Object)problemsModel);
        Dataset dataset = this.testObj.getPropertiesDataset(mockSubjects);
        Assert.assertTrue((boolean)dataset.getDefaultModel().containsAll(treeStream.asModel()));
        Assert.assertTrue((boolean)dataset.getDefaultModel().containsAll(propertiesStream.asModel()));
        Assert.assertEquals((Object)this.mockResource, (Object)dataset.getContext().get(Symbol.create((String)"uri")));
    }

    @Test
    public void testGetVersionDataset() throws Exception {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        GraphSubjects mockSubjects = (GraphSubjects)Mockito.mock(GraphSubjects.class);
        Mockito.when((Object)JcrRdfTools.withContext((GraphSubjects)mockSubjects, (Session)this.mockSession)).thenReturn((Object)this.mockJcrRdfTools);
        Mockito.when((Object)mockSubjects.getGraphSubject(this.mockNode)).thenReturn((Object)this.mockResource);
        RdfStream versionsStream = new RdfStream();
        Mockito.when((Object)this.mockJcrRdfTools.getVersionTriples((javax.jcr.Node)Matchers.any(javax.jcr.Node.class))).thenReturn((Object)versionsStream);
        RdfStream result = this.testObj.getVersionTriples(mockSubjects);
        Assert.assertEquals((Object)versionsStream, (Object)result);
    }

    @Test
    public void testAddVersionLabel() throws RepositoryException {
        VersionHistory mockVersionHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Version mockVersion = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)mockVersion.getName()).thenReturn((Object)"uuid");
        Workspace mockWorkspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)mockWorkspace);
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        Mockito.when((Object)mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getBaseVersion(Matchers.anyString())).thenReturn((Object)mockVersion);
        Mockito.when((Object)mockVersionManager.getVersionHistory(Matchers.anyString())).thenReturn((Object)mockVersionHistory);
        this.testObj.addVersionLabel("v1.0.0");
        ((VersionHistory)Mockito.verify((Object)mockVersionHistory)).addVersionLabel("uuid", "v1.0.0", true);
    }

    @Test
    public void testGetBaseVersion() throws RepositoryException {
        Version mockVersion = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)mockVersion.getName()).thenReturn((Object)"uuid");
        Workspace mockWorkspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)mockWorkspace);
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        Mockito.when((Object)mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getBaseVersion(Matchers.anyString())).thenReturn((Object)mockVersion);
        this.testObj.getBaseVersion();
        ((VersionManager)Mockito.verify((Object)mockVersionManager)).getBaseVersion(Matchers.anyString());
    }

    @Test
    public void testGetVersionHistory() throws RepositoryException {
        VersionHistory mockVersionHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Version mockVersion = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)mockVersion.getName()).thenReturn((Object)"uuid");
        Workspace mockWorkspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)mockWorkspace);
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        Mockito.when((Object)mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getVersionHistory(Matchers.anyString())).thenReturn((Object)mockVersionHistory);
        this.testObj.getVersionHistory();
        ((VersionManager)Mockito.verify((Object)mockVersionManager)).getVersionHistory(Matchers.anyString());
    }

    @Test
    public void testIsNew() {
        Mockito.when((Object)this.mockNode.isNew()).thenReturn((Object)true);
        Assert.assertTrue((String)"resource state should be the same as the node state", (boolean)this.testObj.isNew());
    }

    @Test
    public void testIsNotNew() {
        Mockito.when((Object)this.mockNode.isNew()).thenReturn((Object)false);
        Assert.assertFalse((String)"resource state should be the same as the node state", (boolean)this.testObj.isNew());
    }

    @Test
    public void testReplacePropertiesDataset() throws Exception {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        DefaultGraphSubjects defaultGraphSubjects = new DefaultGraphSubjects(this.mockSession);
        Mockito.when((Object)JcrRdfTools.withContext((GraphSubjects)defaultGraphSubjects, (Session)this.mockSession)).thenReturn((Object)this.mockJcrRdfTools);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/xyz");
        Model propertiesModel = ModelFactory.createDefaultModel();
        propertiesModel.add(propertiesModel.createResource("a"), propertiesModel.createProperty("b"), "c");
        propertiesModel.add(propertiesModel.createResource("i"), propertiesModel.createProperty("j"), "k");
        propertiesModel.add(propertiesModel.createResource("x"), propertiesModel.createProperty("y"), "z");
        RdfStream propertiesStream = RdfStream.fromModel((Model)propertiesModel);
        Mockito.when((Object)this.mockJcrRdfTools.getJcrTriples(this.mockNode)).thenReturn((Object)propertiesStream);
        RdfStream treeStream = new RdfStream();
        Mockito.when((Object)this.mockJcrRdfTools.getTreeTriples(this.mockNode)).thenReturn((Object)treeStream);
        Model problemsModel = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getProblemsModel()).thenReturn((Object)problemsModel);
        Model replacementModel = ModelFactory.createDefaultModel();
        replacementModel.add(replacementModel.createResource("a"), replacementModel.createProperty("b"), "n");
        replacementModel.add(replacementModel.createResource("i"), replacementModel.createProperty("j"), "k");
        Model replacements = this.testObj.replaceProperties((GraphSubjects)defaultGraphSubjects, replacementModel).asModel();
        Assert.assertTrue((boolean)replacements.containsAll(replacementModel));
        Assert.assertFalse((boolean)problemsModel.contains(propertiesModel.createResource("x"), propertiesModel.createProperty("y"), "z"));
    }

    @Test
    public void shouldGetEtagForAnObject() throws RepositoryException {
        Property mockMod = (Property)Mockito.mock(Property.class);
        Calendar modDate = Calendar.getInstance();
        modDate.set(2013, 6, 30, 0, 0, 0);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"some-path");
        Mockito.when((Object)this.mockNode.hasProperty("jcr:lastModified")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getProperty("jcr:lastModified")).thenReturn((Object)mockMod);
        Mockito.when((Object)mockMod.getDate()).thenReturn((Object)modDate);
        Assert.assertEquals((Object)DigestUtils.shaHex((String)("some-path" + this.testObj.getLastModifiedDate().toString())), (Object)this.testObj.getEtagValue());
    }
}

