/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.TransactionImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TransactionTest {
    private Transaction testObj;
    private static final String USER_NAME = "test";
    @Mock
    private Session mockSession;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new TransactionImpl(this.mockSession, USER_NAME);
    }

    @Test
    public void testRollback() throws RepositoryException {
        this.testObj.rollback();
        ((Session)Mockito.verify((Object)this.mockSession)).refresh(false);
        ((Session)Mockito.verify((Object)this.mockSession)).logout();
        Assert.assertEquals((Object)Transaction.State.ROLLED_BACK, (Object)this.testObj.getState());
        long update = this.testObj.getExpires().getTime();
        Assert.assertTrue((update <= System.currentTimeMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testCommit() throws RepositoryException {
        this.testObj.commit(null);
        ((Session)Mockito.verify((Object)this.mockSession)).save();
        ((Session)Mockito.verify((Object)this.mockSession)).logout();
        Assert.assertEquals((Object)Transaction.State.COMMITED, (Object)this.testObj.getState());
        long update = this.testObj.getExpires().getTime();
        Assert.assertTrue((update <= System.currentTimeMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testExpire() throws RepositoryException {
        long orig = this.testObj.getExpires().getTime();
        this.testObj.expire();
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).save();
        ((Session)Mockito.verify((Object)this.mockSession)).logout();
        long update = this.testObj.getExpires().getTime();
        Assert.assertTrue((update < orig ? 1 : 0) != 0);
        Assert.assertTrue((update <= System.currentTimeMillis() ? 1 : 0) != 0);
        Assert.assertTrue((update < orig ? 1 : 0) != 0);
    }

    @Test
    public void testExpiryUpdate() {
        long orig = this.testObj.getExpires().getTime();
        this.testObj.updateExpiryDate();
        long update = this.testObj.getExpires().getTime();
        Assert.assertTrue((String)("Unexpected negative expiry delta: " + (update - orig)), (update - orig >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testState() throws RepositoryException {
        Assert.assertEquals((Object)Transaction.State.NEW, (Object)this.testObj.getState());
        Mockito.when((Object)this.mockSession.hasPendingChanges()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Assert.assertEquals((Object)Transaction.State.DIRTY, (Object)this.testObj.getState());
        this.testObj.commit(null);
    }

    @Test
    public void testUserAssociation() {
        String otherUser = "dummy";
        Assert.assertTrue((String)"Transaction expected to be associated with user test", (boolean)this.testObj.isAssociatedWithUser(USER_NAME));
        Assert.assertFalse((String)"Transaction should not be associated with the userdummy", (boolean)this.testObj.isAssociatedWithUser("dummy"));
        Assert.assertFalse((String)"Transaction should not be associated with an empty user", (boolean)this.testObj.isAssociatedWithUser(null));
        this.testObj = new TransactionImpl(this.mockSession, null);
        Assert.assertTrue((String)"Transaction should not be associated with a user", (boolean)this.testObj.isAssociatedWithUser(null));
        Assert.assertFalse((String)"Transaction should not be associated with a user", (boolean)this.testObj.isAssociatedWithUser(USER_NAME));
    }
}

