/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.TxAwareSession;
import org.fcrepo.kernel.TxSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TxAwareSessionTest {
    @Mock
    private Session mockSession;
    private Session testObj;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = TxAwareSession.newInstance((Session)this.mockSession, (String)"txid");
    }

    @Test
    public void shouldProxyMethods() throws RepositoryException {
        this.testObj.getItem("/xyz");
        ((Session)Mockito.verify((Object)this.mockSession)).getItem("/xyz");
    }

    @Test
    public void shouldWrapImpersonateToReturnAnotherTxAwareSession() throws RepositoryException {
        Credentials mockCredentials = (Credentials)Mockito.mock(Credentials.class);
        Mockito.when((Object)this.mockSession.impersonate(mockCredentials)).thenReturn((Object)this.mockSession);
        Session s = this.testObj.impersonate(mockCredentials);
        Assert.assertTrue((boolean)(s instanceof TxSession));
        Assert.assertEquals((Object)((TxSession)this.testObj).getTxId(), (Object)((TxSession)s).getTxId());
    }

    @Test
    public void shouldMakeLogoutANoop() {
        this.testObj.logout();
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).logout();
    }

    @Test
    public void shouldMakeSaveANoop() throws RepositoryException {
        this.testObj.save();
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).save();
    }
}

