/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.observer;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.observer.DefaultFilter;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.Repository;

public class DefaultFilterTest {
    private DefaultFilter testObj;
    @Mock
    private Session mockSession;
    @Mock
    private Repository mockRepo;
    @Mock
    private Event mockEvent;
    @Mock
    private Node mockNode;
    @Mock
    private Property mockProperty;
    private static final String testId = UUID.randomUUID().toString();
    private static final String testPath = "/foo/bar";

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockEvent.getPath()).thenReturn((Object)testPath);
        Mockito.when((Object)this.mockEvent.getIdentifier()).thenReturn((Object)testId);
        Mockito.when((Object)this.mockEvent.getType()).thenReturn((Object)1);
        Mockito.when((Object)this.mockNode.isNode()).thenReturn((Object)true);
        this.testObj = new DefaultFilter();
        Mockito.when((Object)this.mockRepo.login()).thenReturn((Object)this.mockSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldApplyToObjectOrDatastream() throws Exception {
        Mockito.when((Object)this.mockSession.getItem(testPath)).thenReturn((Object)this.mockNode);
        Predicate holdO = FedoraTypesUtils.isFedoraObject;
        try {
            FedoraTypesUtils.isFedoraObject = Predicates.alwaysTrue();
            Assert.assertTrue((boolean)this.testObj.getFilter(this.mockSession).apply((Object)this.mockEvent));
        }
        finally {
            FedoraTypesUtils.isFedoraObject = holdO;
        }
    }

    @Test
    public void shouldNotApplyToNonExistentNodes() throws Exception {
        Mockito.when((Object)this.mockSession.getNodeByIdentifier(testId)).thenThrow(new Throwable[]{new PathNotFoundException("Expected.")});
        Assert.assertFalse((boolean)this.testObj.getFilter(this.mockSession).apply((Object)this.mockEvent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotApplyToNonFedoraNodes() throws Exception {
        Mockito.when((Object)this.mockSession.getNode(testPath)).thenReturn((Object)this.mockNode);
        Predicate holdO = FedoraTypesUtils.isFedoraObject;
        Predicate hold1 = FedoraTypesUtils.isFedoraDatastream;
        try {
            FedoraTypesUtils.isFedoraObject = Predicates.alwaysFalse();
            FedoraTypesUtils.isFedoraDatastream = Predicates.alwaysFalse();
            Assert.assertFalse((boolean)this.testObj.getFilter(this.mockSession).apply((Object)this.mockEvent));
        }
        finally {
            FedoraTypesUtils.isFedoraObject = holdO;
            FedoraTypesUtils.isFedoraDatastream = hold1;
        }
    }

    @Test(expected=RuntimeException.class)
    public void testBadItem() throws RepositoryException {
        Mockito.when((Object)this.mockEvent.getType()).thenReturn((Object)4);
        Mockito.when((Object)this.mockSession.getNode("/foo")).thenThrow(new Throwable[]{new RepositoryException("Expected.")});
        Mockito.when((Object)this.mockProperty.isNode()).thenReturn((Object)false);
        this.testObj.getFilter(this.mockSession).apply((Object)this.mockEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isNode()).thenReturn((Object)false);
        Mockito.when((Object)this.mockProperty.getParent()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockSession.getItem(testPath)).thenReturn((Object)this.mockProperty);
        Predicate holdO = FedoraTypesUtils.isFedoraObject;
        try {
            FedoraTypesUtils.isFedoraObject = Predicates.alwaysTrue();
            Assert.assertNotNull((Object)this.testObj.getFilter(this.mockSession).apply((Object)this.mockEvent));
        }
        finally {
            FedoraTypesUtils.isFedoraObject = holdO;
        }
    }
}

