/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.observer;

import com.google.common.base.Predicate;
import com.google.common.eventbus.EventBus;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.fcrepo.kernel.observer.EventFilter;
import org.fcrepo.kernel.observer.FedoraEvent;
import org.fcrepo.kernel.observer.NOOPFilter;
import org.fcrepo.kernel.observer.SimpleObserver;
import org.fcrepo.kernel.observer.eventmappings.OneToOne;
import org.fcrepo.kernel.utils.TestHelpers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.api.Repository;

public class SimpleObserverTest {
    private SimpleObserver testObserver;
    @Mock
    private ObservationManager mockOM;
    @Mock
    private Repository mockRepository;
    @Mock
    private Session mockSession;
    @Mock
    private Workspace mockWS;
    @Mock
    private EventBus mockBus;
    @Mock
    private Event mockEvent;
    @Mock
    private EventIterator mockEvents;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockRepository.login()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockEvents.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)this.mockEvents.next()).thenReturn((Object)this.mockEvent);
        this.testObserver = new SimpleObserver();
        TestHelpers.setField(this.testObserver, "repository", this.mockRepository);
        TestHelpers.setField(this.testObserver, "eventMapper", new OneToOne());
        TestHelpers.setField(this.testObserver, "eventFilter", new NOOPFilter());
        TestHelpers.setField(this.testObserver, "eventBus", this.mockBus);
        TestHelpers.setField(this.testObserver, "session", this.mockSession);
    }

    @Test
    public void testBuildListener() throws Exception {
        Mockito.when((Object)this.mockWS.getObservationManager()).thenReturn((Object)this.mockOM);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWS);
        this.testObserver.buildListener();
        ((ObservationManager)Mockito.verify((Object)this.mockOM)).addEventListener((EventListener)this.testObserver, SimpleObserver.EVENT_TYPES.intValue(), "/", true, null, null, false);
    }

    @Test
    public void testOnEvent() throws Exception {
        this.testObserver.onEvent(this.mockEvents);
        ((EventBus)Mockito.verify((Object)this.mockBus)).post(Matchers.any(FedoraEvent.class));
    }

    @Test
    public void testOnEventAllFiltered() throws Exception {
        TestHelpers.setField(this.testObserver, "eventFilter", new NoPassFilter());
        this.testObserver.onEvent(this.mockEvents);
        ((EventBus)Mockito.verify((Object)this.mockBus, (VerificationMode)Mockito.never())).post(Matchers.any(FedoraEvent.class));
    }

    private class NoPassFilter
    implements EventFilter {
        private NoPassFilter() {
        }

        public boolean apply(Event input) {
            return false;
        }

        public Predicate<Event> getFilter(Session session) {
            return this;
        }
    }
}

