/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.util.Symbol;
import javax.jcr.Node;
import javax.jcr.Session;
import org.fcrepo.kernel.DummyURIResource;
import org.fcrepo.kernel.rdf.GraphProperties;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.rdf.JcrRdfTools;
import org.fcrepo.kernel.rdf.impl.JcrGraphProperties;
import org.fcrepo.kernel.utils.JcrPropertyStatementListener;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "org.apache.xerces.*", "javax.xml.*", "org.xml.sax.*", "javax.management.*", "com.hp.hpl.*", "com.google.common.*", "com.codahale.metrics.*"})
@PrepareForTest(value={JcrRdfTools.class, JcrPropertyStatementListener.class})
public class JcrGraphPropertiesTest {
    private JcrGraphProperties testObj = new JcrGraphProperties();
    @Mock
    Node mockNode;
    @Mock
    GraphSubjects mockSubjects;

    @Test
    public void testGetPropertiesDataset() throws Exception {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        JcrRdfTools mockJcrRdfTools = (JcrRdfTools)Mockito.mock(JcrRdfTools.class);
        Mockito.when((Object)JcrRdfTools.withContext((GraphSubjects)this.mockSubjects, (Session)this.mockNode.getSession())).thenReturn((Object)mockJcrRdfTools);
        DummyURIResource mockResource = new DummyURIResource("http://fedora.info/definitions/v4/rest-api#xyz");
        Mockito.when((Object)this.mockSubjects.getGraphSubject(this.mockNode)).thenReturn((Object)mockResource);
        RdfStream propertiesStream = new RdfStream();
        Mockito.when((Object)mockJcrRdfTools.getJcrTriples(this.mockNode)).thenReturn((Object)propertiesStream);
        RdfStream treeStream = new RdfStream();
        Mockito.when((Object)mockJcrRdfTools.getTreeTriples(this.mockNode)).thenReturn((Object)treeStream);
        Model problemsModel = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getProblemsModel()).thenReturn((Object)problemsModel);
        Dataset dataset = this.testObj.getProperties(this.mockNode, this.mockSubjects, 0, -1);
        Assert.assertTrue((boolean)dataset.containsNamedModel("tree"));
        Assert.assertEquals((Object)treeStream, (Object)RdfStream.fromModel((Model)dataset.getNamedModel("tree")));
        Assert.assertEquals((Object)propertiesStream, (Object)RdfStream.fromModel((Model)dataset.getDefaultModel()));
        Assert.assertEquals((Object)"http://fedora.info/definitions/v4/rest-api#xyz", (Object)dataset.getContext().get(Symbol.create((String)"uri")));
    }

    @Test
    public void testGetPropertiesDefaultLimits() throws Exception {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        JcrRdfTools mockJcrRdfTools = (JcrRdfTools)Mockito.mock(JcrRdfTools.class);
        Mockito.when((Object)JcrRdfTools.withContext((GraphSubjects)this.mockSubjects, (Session)this.mockNode.getSession())).thenReturn((Object)mockJcrRdfTools);
        DummyURIResource mockResource = new DummyURIResource("http://fedora.info/definitions/v4/rest-api#xyz");
        Mockito.when((Object)this.mockSubjects.getGraphSubject(this.mockNode)).thenReturn((Object)mockResource);
        RdfStream propertiesStream = new RdfStream();
        Mockito.when((Object)mockJcrRdfTools.getJcrTriples(this.mockNode)).thenReturn((Object)propertiesStream);
        RdfStream treeStream = new RdfStream();
        Mockito.when((Object)mockJcrRdfTools.getTreeTriples(this.mockNode)).thenReturn((Object)treeStream);
        Model problemsModel = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getProblemsModel()).thenReturn((Object)problemsModel);
        Dataset dataset = this.testObj.getProperties(this.mockNode, this.mockSubjects);
        PowerMockito.verifyStatic();
        mockJcrRdfTools.getTreeTriples(this.mockNode);
        Assert.assertTrue((boolean)dataset.containsNamedModel("tree"));
        Assert.assertEquals((Object)treeStream, (Object)RdfStream.fromModel((Model)dataset.getNamedModel("tree")));
        Assert.assertEquals((Object)propertiesStream, (Object)RdfStream.fromModel((Model)dataset.getDefaultModel()));
        Assert.assertEquals((Object)"http://fedora.info/definitions/v4/rest-api#xyz", (Object)dataset.getContext().get(Symbol.create((String)"uri")));
        Assert.assertTrue((boolean)dataset.containsNamedModel("problems"));
    }

    @Test
    public void testGetPropertiesDatasetDefaults() throws Exception {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        JcrRdfTools mockJcrRdfTools = (JcrRdfTools)Mockito.mock(JcrRdfTools.class);
        Mockito.when((Object)JcrRdfTools.withContext((GraphSubjects)this.mockSubjects, (Session)this.mockNode.getSession())).thenReturn((Object)mockJcrRdfTools);
        DummyURIResource mockResource = new DummyURIResource("http://fedora.info/definitions/v4/rest-api#xyz");
        Mockito.when((Object)this.mockSubjects.getGraphSubject(this.mockNode)).thenReturn((Object)mockResource);
        RdfStream propertiesStream = new RdfStream();
        Mockito.when((Object)mockJcrRdfTools.getJcrTriples(this.mockNode)).thenReturn((Object)propertiesStream);
        RdfStream treeStream = new RdfStream();
        Mockito.when((Object)mockJcrRdfTools.getTreeTriples(this.mockNode)).thenReturn((Object)treeStream);
        Model problemsModel = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getProblemsModel()).thenReturn((Object)problemsModel);
        Dataset dataset = this.testObj.getProperties(this.mockNode, this.mockSubjects);
        Assert.assertTrue((boolean)dataset.containsNamedModel("tree"));
        Assert.assertEquals((Object)treeStream, (Object)RdfStream.fromModel((Model)dataset.getNamedModel("tree")));
        Assert.assertEquals((Object)propertiesStream, (Object)RdfStream.fromModel((Model)dataset.getDefaultModel()));
        Assert.assertEquals((Object)"http://fedora.info/definitions/v4/rest-api#xyz", (Object)dataset.getContext().get(GraphProperties.URI_SYMBOL));
    }
}

