/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRdfContextTest {
    @Mock
    private Node mockNode;
    @Mock
    private NodeType mockPrimaryNodeType;
    @Mock
    private NodeType mockMixinNodeType;
    @Mock
    private NodeType mockPrimarySuperNodeType;
    @Mock
    private NodeType mockMixinSuperNodeType;
    @Mock
    private GraphSubjects mockGraphSubjects;
    @Mock
    private Session mockSession;
    @Mock
    private Repository mockRepository;
    @Mock
    private LowLevelStorageService mockLowLevelStorageService;
    @Mock
    private NamespaceRegistry mockNamespaceRegistry;
    @Mock
    private Workspace mockWorkspace;
    private static final String mockNodeName = "mockNode";
    private static final String mockNodeTypePrefix = "jcr";
    private static final String mockPrimaryNodeTypeName = "somePrimaryType";
    private static final String mockMixinNodeTypeName = "someMixinType";
    private static final String mockPrimarySuperNodeTypeName = "somePrimarySuperType";
    private static final String mockMixinSuperNodeTypeName = "someMixinSuperType";
    private static final Resource mockNodeSubject = ResourceFactory.createResource();
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeRdfContextTest.class);

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockPrimaryNodeType);
        Mockito.when((Object)this.mockPrimaryNodeType.getName()).thenReturn((Object)"jcr:somePrimaryType");
        Mockito.when((Object)this.mockNode.getName()).thenReturn((Object)mockNodeName);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{this.mockMixinNodeType});
        Mockito.when((Object)this.mockMixinNodeType.getName()).thenReturn((Object)"jcr:someMixinType");
        Mockito.when((Object)this.mockPrimaryNodeType.getSupertypes()).thenReturn((Object)new NodeType[]{this.mockPrimarySuperNodeType});
        Mockito.when((Object)this.mockPrimarySuperNodeType.getName()).thenReturn((Object)"jcr:somePrimarySuperType");
        Mockito.when((Object)this.mockMixinNodeType.getSupertypes()).thenReturn((Object)new NodeType[]{this.mockMixinSuperNodeType});
        Mockito.when((Object)this.mockMixinSuperNodeType.getName()).thenReturn((Object)"jcr:someMixinSuperType");
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getRepository()).thenReturn((Object)this.mockRepository);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
        Mockito.when((Object)this.mockNamespaceRegistry.getURI(mockNodeTypePrefix)).thenReturn((Object)"http://www.jcp.org/jcr/1.0");
        Mockito.when((Object)this.mockGraphSubjects.getGraphSubject(this.mockNode)).thenReturn((Object)mockNodeSubject);
    }

    @Test
    public void testRdfTypesForNodetypes() throws RepositoryException, IOException {
        Model actual = new NodeRdfContext(this.mockNode, this.mockGraphSubjects, this.mockLowLevelStorageService).asModel();
        Resource expectedRdfTypePrimary = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#somePrimaryType");
        Resource expectedRdfTypeMixin = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#someMixinType");
        Resource expectedRdfTypePrimarySuper = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#somePrimarySuperType");
        Resource expectedRdfTypeMixinSuper = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#someMixinSuperType");
        NodeRdfContextTest.logRdf("Constructed RDF: ", actual);
        Assert.assertTrue((String)"Didn't find RDF type triple for primarytype!", (boolean)actual.contains(mockNodeSubject, RDF.type, (RDFNode)expectedRdfTypePrimary));
        Assert.assertTrue((String)"Didn't find RDF type triple for mixintype!", (boolean)actual.contains(mockNodeSubject, RDF.type, (RDFNode)expectedRdfTypeMixin));
        Assert.assertTrue((String)"Didn't find RDF type triple for primarysupertype!", (boolean)actual.contains(mockNodeSubject, RDF.type, (RDFNode)expectedRdfTypePrimarySuper));
        Assert.assertTrue((String)"Didn't find RDF type triple for mixinsupertype!", (boolean)actual.contains(mockNodeSubject, RDF.type, (RDFNode)expectedRdfTypeMixinSuper));
    }

    @Test(expected=RuntimeException.class)
    public void testBadRepository() throws RepositoryException {
        Mockito.when((Object)this.mockNamespaceRegistry.getURI(mockNodeTypePrefix)).thenThrow(new Throwable[]{new RepositoryException("Expected.")});
        new NodeRdfContext(this.mockNode, this.mockGraphSubjects, this.mockLowLevelStorageService).asModel();
    }

    private static void logRdf(String message, Model model) throws IOException {
        LOGGER.debug(message);
        try (StringWriter w = new StringWriter();){
            model.write((Writer)w);
            LOGGER.debug("\n" + ((Object)w).toString());
        }
    }
}

