/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl.mappings;

import com.google.common.collect.ImmutableSet;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.kernel.rdf.impl.mappings.ItemDefinitionToTriples;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.Namespaced;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemDefinitionToTriplesTest {
    @InjectMocks
    private ItemDefinitionToTriples<ItemDefinition> testMapper;
    @Mock
    private NamespacedItemDefinition mockItemDefinition;
    @Mock
    private NamespacedNodeType mockNodeType;
    @Mock
    private Node mockRDFNode = NodeFactory.createURI((String)"mock:domain");
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemDefinitionToTriplesTest.class);

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockItemDefinition.getName()).thenReturn((Object)"mock:ItemDefinition");
        Mockito.when((Object)this.mockItemDefinition.getLocalName()).thenReturn((Object)"ItemDefinition");
        Mockito.when((Object)this.mockItemDefinition.getNamespaceURI()).thenReturn((Object)"mock");
    }

    @Test
    public void testGoodDefinition() throws RepositoryException {
        ImmutableSet results = ImmutableSet.copyOf((Iterator)this.testMapper.apply((ItemDefinition)this.mockItemDefinition));
        LOGGER.debug("Created RDF: ");
        for (Triple t : results) {
            LOGGER.debug("{}", (Object)t);
        }
        Node subject = ItemDefinitionToTriples.getResource((ItemDefinition)this.mockItemDefinition).asNode();
        Assert.assertTrue((boolean)results.contains(Triple.create((Node)subject, (Node)RDF.type.asNode(), (Node)RDF.Property.asNode())));
        Assert.assertTrue((boolean)results.contains(Triple.create((Node)subject, (Node)RDFS.label.asNode(), (Node)NodeFactory.createLiteral((String)this.mockItemDefinition.getName()))));
        Assert.assertTrue((boolean)results.contains(Triple.create((Node)subject, (Node)RDFS.domain.asNode(), (Node)this.mockRDFNode)));
    }

    @Test(expected=RuntimeException.class)
    public void testBadDefinition() throws RepositoryException {
        Mockito.when((Object)this.mockItemDefinition.getNamespaceURI()).thenThrow(new Throwable[]{new RepositoryException("Expected.")});
        this.testMapper.apply((ItemDefinition)this.mockItemDefinition);
    }

    @Test
    public void testGetResourceFromNodeType() throws RepositoryException {
        Mockito.when((Object)this.mockNodeType.getNamespaceURI()).thenReturn((Object)"namespace#");
        Mockito.when((Object)this.mockNodeType.getLocalName()).thenReturn((Object)"localname");
        Resource answer = ItemDefinitionToTriples.getResource((NodeType)this.mockNodeType);
        Assert.assertEquals((Object)"namespace#", (Object)answer.getNameSpace());
        Assert.assertEquals((Object)"localname", (Object)answer.getLocalName());
    }

    private static interface NamespacedNodeType
    extends Namespaced,
    NodeType {
    }

    private static interface NamespacedItemDefinition
    extends Namespaced,
    ItemDefinition {
    }
}

