/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl.mappings;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import org.fcrepo.kernel.rdf.impl.mappings.ZippingIterator;
import org.junit.Assert;
import org.junit.Test;

public class ZippingIteratorTest {
    private ZippingIterator<Object, Object> zip;
    Iterator<Object> values;
    Iterator<Function<Object, Object>> functions;
    private static Object from1 = new Object();
    private static Object from2 = new Object();
    private static Object to1 = new Object();
    private static Object to2 = new Object();
    private static final Function<Object, Object> f = Functions.forMap((Map)ImmutableMap.of((Object)from1, (Object)to1, (Object)from2, (Object)to2));

    @Test
    public void testMoreValuesThanFunctions() {
        this.values = Iterators.forArray((Object[])new Object[]{from1, from2});
        this.functions = Iterators.singletonIterator(f);
        this.zip = new ZippingIterator(this.values, this.functions);
        Assert.assertEquals((String)"Got wrong value!", (Object)to1, (Object)this.zip.next());
        Assert.assertFalse((String)"Too many values!", (boolean)this.zip.hasNext());
    }

    @Test
    public void testMoreFunctionsThanValues() {
        this.values = Iterators.singletonIterator((Object)from1);
        this.functions = Iterators.forArray((Object[])new Function[]{f, f});
        this.zip = new ZippingIterator(this.values, this.functions);
        Assert.assertEquals((String)"Got wrong value!", (Object)to1, (Object)this.zip.next());
        Assert.assertFalse((String)"Too many values!", (boolean)this.zip.hasNext());
    }
}

