/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import java.io.InputStream;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeTypeIterator;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.services.NodeServiceImpl;
import org.fcrepo.kernel.services.ServiceHelpers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={ServiceHelpers.class})
public class NodeServiceTest {
    @Mock
    private NodeTypeIterator mockNTI;
    @Mock
    private NodeTypeManager mockNodeTypeManager;
    @Mock
    private Session mockSession;
    @Mock
    private Node mockRoot;
    @Mock
    private Node mockObjNode;
    @Mock
    private Workspace mockWorkspace;
    private NodeService testObj;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new NodeServiceImpl();
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNodeTypeManager()).thenReturn((Object)this.mockNodeTypeManager);
        Mockito.when((Object)this.mockNodeTypeManager.getAllNodeTypes()).thenReturn((Object)this.mockNTI);
    }

    @Test
    public void testGetObjectNames() throws RepositoryException {
        String objPath = "";
        Mockito.when((Object)this.mockObjNode.getName()).thenReturn((Object)"foo");
        Mockito.when((Object)this.mockObjNode.isNodeType("nt:folder")).thenReturn((Object)true);
        NodeIterator mockIter = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)mockIter.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)mockIter.nextNode()).thenReturn((Object)this.mockObjNode).thenThrow(new Class[]{IndexOutOfBoundsException.class});
        Mockito.when((Object)this.mockRoot.getNodes()).thenReturn((Object)mockIter);
        Mockito.when((Object)this.mockSession.getNode("")).thenReturn((Object)this.mockRoot);
        Set actual = this.testObj.getObjectNames(this.mockSession, "");
        ((Session)Mockito.verify((Object)this.mockSession)).getNode("");
        Assert.assertEquals((long)1L, (long)actual.size());
        Assert.assertEquals((Object)"foo", actual.iterator().next());
    }

    @Test
    public void testDeleteOBject() throws RepositoryException {
        String objPath = "foo";
        Node mockObjectsNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockRoot.getNode("objects")).thenReturn((Object)mockObjectsNode);
        Mockito.when((Object)this.mockSession.getNode("foo")).thenReturn((Object)this.mockObjNode);
        PowerMockito.mockStatic(ServiceHelpers.class, (Class[])new Class[0]);
        this.testObj.deleteObject(this.mockSession, "foo");
        ((Session)Mockito.verify((Object)this.mockSession)).getNode("foo");
        ((Node)Mockito.verify((Object)this.mockObjNode)).remove();
    }

    @Test
    public void testCopyObject() throws RepositoryException {
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        this.testObj.copyObject(this.mockSession, "foo", "bar");
        ((Workspace)Mockito.verify((Object)this.mockWorkspace)).copy("foo", "bar");
    }

    @Test
    public void testMoveObject() throws RepositoryException {
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        this.testObj.moveObject(this.mockSession, "foo", "bar");
        ((Workspace)Mockito.verify((Object)this.mockWorkspace)).move("foo", "bar");
    }

    @Test
    public void testExists() throws RepositoryException {
        String existsPath = "/foo/bar/exists";
        Mockito.when((Object)this.mockSession.nodeExists("/foo/bar/exists")).thenReturn((Object)true);
        Assert.assertEquals((Object)true, (Object)this.testObj.exists(this.mockSession, "/foo/bar/exists"));
        Assert.assertEquals((Object)false, (Object)this.testObj.exists(this.mockSession, "/foo/bar"));
    }

    @Test
    public void testGetAllNodeTypes() throws RepositoryException {
        NodeTypeIterator actual = this.testObj.getAllNodeTypes(this.mockSession);
        Assert.assertEquals((Object)this.mockNTI, (Object)actual);
    }

    @Test
    public void testGetNodeTypes() throws Exception {
        Mockito.when((Object)this.mockNodeTypeManager.getPrimaryNodeTypes()).thenReturn(Mockito.mock(NodeTypeIterator.class));
        Mockito.when((Object)this.mockNodeTypeManager.getMixinNodeTypes()).thenReturn(Mockito.mock(NodeTypeIterator.class));
        this.testObj.getNodeTypes(this.mockSession);
        ((NodeTypeManager)Mockito.verify((Object)this.mockNodeTypeManager)).getPrimaryNodeTypes();
        ((NodeTypeManager)Mockito.verify((Object)this.mockNodeTypeManager)).getMixinNodeTypes();
    }

    @Test
    public void testRegisterNodeTypes() throws Exception {
        InputStream mockInputStream = (InputStream)Mockito.mock(InputStream.class);
        this.testObj.registerNodeTypes(this.mockSession, mockInputStream);
        ((NodeTypeManager)Mockito.verify((Object)this.mockNodeTypeManager)).registerNodeTypes(mockInputStream, true);
    }
}

