/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.version.VersionManager;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.services.TransactionService;
import org.fcrepo.kernel.services.TransactionServiceImpl;
import org.fcrepo.kernel.services.VersionService;
import org.fcrepo.kernel.services.VersionServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class VersionServiceTest {
    private static final String USER_NAME = "test";
    private VersionService testObj;
    private TransactionService txService;
    @Mock
    private Session s;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private VersionManager mockVM;

    @Before
    public void setup() throws Exception {
        this.txService = new TransactionServiceImpl();
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new VersionServiceImpl();
        this.testObj.setTxService(this.txService);
        this.txService.setVersionService(this.testObj);
        this.s = (Session)Mockito.mock(Session.class);
        this.mockWorkspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.mockWorkspace.getName()).thenReturn((Object)"default");
        Mockito.when((Object)this.s.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        this.mockVM = (VersionManager)Mockito.mock(VersionManager.class);
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)this.mockVM);
        Node versionedNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)versionedNode.getPath()).thenReturn((Object)"/example-versioned");
        Mockito.when((Object)versionedNode.getSession()).thenReturn((Object)this.s);
        Mockito.when((Object)versionedNode.isNodeType("mix:versionable")).thenReturn((Object)true);
        Mockito.when((Object)this.s.getNode("/example-versioned")).thenReturn((Object)versionedNode);
        Node autoversionedNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)autoversionedNode.getPath()).thenReturn((Object)"/example-auto-versioned");
        Mockito.when((Object)autoversionedNode.getSession()).thenReturn((Object)this.s);
        Mockito.when((Object)autoversionedNode.isNodeType("mix:versionable")).thenReturn((Object)true);
        Mockito.when((Object)this.s.getNode("/example-auto-versioned")).thenReturn((Object)autoversionedNode);
        Property autoVersionProperty = (Property)Mockito.mock(Property.class);
        Value autoVersionValue = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)autoVersionValue.getString()).thenReturn((Object)"auto-version");
        Mockito.when((Object)autoVersionProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)autoVersionProperty.getValues()).thenReturn((Object)new Value[]{autoVersionValue});
        Mockito.when((Object)autoversionedNode.hasProperty("fedoraconfig:versioningPolicy")).thenReturn((Object)true);
        Mockito.when((Object)autoversionedNode.getProperty("fedoraconfig:versioningPolicy")).thenReturn((Object)autoVersionProperty);
        Node unversionedNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)unversionedNode.getPath()).thenReturn((Object)"/example-unversioned");
        Mockito.when((Object)unversionedNode.getSession()).thenReturn((Object)this.s);
        Mockito.when((Object)unversionedNode.isNodeType("mix:versionable")).thenReturn((Object)false);
        Mockito.when((Object)this.s.getNode("/example-unversioned")).thenReturn((Object)unversionedNode);
    }

    @Test
    public void testCheckpoint() throws Exception {
        this.testObj.nodeUpdated(this.s, "/example-versioned");
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.never())).checkpoint("/example-versioned");
    }

    @Test
    public void testCheckpointUnversioned() throws Exception {
        this.testObj.nodeUpdated(this.s, "/example-unversioned");
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.never())).checkpoint("/example-unversioned");
    }

    @Test
    public void testCheckpointAutoVersioned() throws Exception {
        this.testObj.nodeUpdated(this.s, "/example-auto-versioned");
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.only())).checkpoint("/example-auto-versioned");
    }

    @Test
    public void testDeferredCheckpointVersioned() throws Exception {
        Transaction t = this.txService.beginTransaction(this.s, USER_NAME);
        this.s = t.getSession();
        Mockito.when((Object)this.s.getNamespaceURI("fcrepo4.tx.id")).thenReturn((Object)t.getId());
        Assert.assertNotNull((String)"Transaction must have started!", (Object)this.txService.getTransaction(this.s.getNode("/example-auto-versioned").getSession()));
        this.testObj.nodeUpdated(this.s, "/example-versioned");
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.never())).checkpoint("/example-versioned");
        this.txService.commit(t.getId());
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.never())).checkpoint("/example-versioned");
    }

    @Test
    public void testDeferredCheckpointUnversioned() throws Exception {
        Transaction t = this.txService.beginTransaction(this.s, USER_NAME);
        this.s = t.getSession();
        Mockito.when((Object)this.s.getNamespaceURI("fcrepo4.tx.id")).thenReturn((Object)t.getId());
        Assert.assertNotNull((String)"Transaction must have started!", (Object)this.txService.getTransaction(this.s.getNode("/example-auto-versioned").getSession()));
        this.testObj.nodeUpdated(this.s, "/example-unversioned");
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.never())).checkpoint("/example-unversioned");
        this.txService.commit(t.getId());
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.never())).checkpoint("/example-unversioned");
    }

    @Test
    public void testDeferredCheckpointAutoVersioned() throws Exception {
        Transaction t = this.txService.beginTransaction(this.s, USER_NAME);
        this.s = t.getSession();
        Mockito.when((Object)this.s.getNamespaceURI("fcrepo4.tx.id")).thenReturn((Object)t.getId());
        Assert.assertNotNull((String)"Transaction must have started!", (Object)this.txService.getTransaction(this.s.getNode("/example-auto-versioned").getSession()));
        this.testObj.nodeUpdated(this.s, "/example-auto-versioned");
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.never())).checkpoint("/example-auto-versioned");
        this.txService.commit(t.getId());
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.only())).checkpoint("/example-auto-versioned");
    }
}

