/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import java.net.URI;
import org.fcrepo.kernel.utils.FixityResult;
import org.fcrepo.kernel.utils.FixityResultImpl;
import org.junit.Assert;
import org.junit.Test;

public class FixityResultTest {
    @Test
    public void testEquals() throws Exception {
        Assert.assertEquals((Object)new FixityResultImpl(100L, new URI("urn:123")), (Object)new FixityResultImpl(100L, new URI("urn:123")));
        Assert.assertNotEquals((Object)new FixityResultImpl(99L, new URI("urn:123")), (Object)new FixityResultImpl(100L, new URI("urn:123")));
        Assert.assertNotEquals((Object)new FixityResultImpl(100L, new URI("urn:321")), (Object)new FixityResultImpl(100L, new URI("urn:123")));
        Assert.assertNotEquals((Object)new FixityResultImpl(99L, new URI("urn:321")), (Object)new FixityResultImpl(100L, new URI("urn:123")));
    }

    @Test
    public void testHashCode() throws Exception {
        Assert.assertEquals((long)new FixityResultImpl(100L, new URI("urn:123")).hashCode(), (long)new FixityResultImpl(100L, new URI("urn:123")).hashCode());
        Assert.assertNotEquals((long)new FixityResultImpl(99L, new URI("urn:123")).hashCode(), (long)new FixityResultImpl(100L, new URI("urn:123")).hashCode());
        Assert.assertNotEquals((long)new FixityResultImpl(100L, new URI("urn:321")).hashCode(), (long)new FixityResultImpl(100L, new URI("urn:123")).hashCode());
        Assert.assertNotEquals((long)new FixityResultImpl(99L, new URI("urn:321")).hashCode(), (long)new FixityResultImpl(100L, new URI("urn:123")).hashCode());
    }

    @Test
    public void testIsSuccess() throws Exception {
        FixityResultImpl result = new FixityResultImpl(100L, new URI("urn:123"));
        result.getStatus().add(FixityResult.FixityState.SUCCESS);
        Assert.assertTrue((String)"expected fixity to be a success", (boolean)result.isSuccess());
        result = new FixityResultImpl(100L, new URI("urn:123"));
        Assert.assertFalse((String)"expected fixity to not be a success", (boolean)result.isSuccess());
    }

    @Test
    public void testMatchesArguments() throws Exception {
        FixityResultImpl result = new FixityResultImpl(100L, new URI("urn:123"));
        Assert.assertTrue((String)"expected fixity to match", (boolean)result.matches(100L, new URI("urn:123")));
        Assert.assertFalse((String)"unexpected match when size differs", (boolean)result.matches(99L, new URI("urn:123")));
        Assert.assertFalse((String)"unexpected match when checksum differs", (boolean)result.matches(100L, new URI("urn:312")));
        Assert.assertFalse((String)"unexpected match when size and checksum differs", (boolean)result.matches(99L, new URI("urn:312")));
    }
}

