/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils.iterators;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.Set;
import org.fcrepo.kernel.utils.iterators.DifferencingIterator;
import org.junit.Assert;
import org.junit.Test;

public class DifferencingIteratorTest {
    private static final String onlyInCollection = "only in collection";
    private static final String commonValue = "common";
    private static final String commonValue2 = "common2";
    private static final String onlyInIteratorValue = "only in iterator";
    private DifferencingIterator<String> testIterator;
    private Set<String> toBeCompared = ImmutableSet.of((Object)"only in collection", (Object)"common");
    private Set<String> toBeCompared2 = ImmutableSet.of((Object)"only in collection", (Object)"common", (Object)"common2");

    @Test
    public void testDifferencing() {
        UnmodifiableIterator i = Iterators.forArray((Object[])new String[]{onlyInIteratorValue, commonValue});
        this.testIterator = new DifferencingIterator(this.toBeCompared, (Iterator)i);
        Assert.assertTrue((String)"Didn't see a first value!", (boolean)this.testIterator.hasNext());
        Assert.assertEquals((String)"Retrieved final results too early!", null, (Object)this.testIterator.notCommon());
        Assert.assertEquals((String)"Retrieved final results too early!", null, (Object)this.testIterator.common());
        Assert.assertEquals((String)"Didn't get the only-in-iterator value!", (Object)onlyInIteratorValue, (Object)this.testIterator.next());
        Assert.assertFalse((String)"Shouldn't see any more values!", (boolean)this.testIterator.hasNext());
        Assert.assertTrue((String)"Didn't find the common value in correct final result!", (boolean)this.testIterator.common().contains(commonValue));
        Assert.assertFalse((String)"Found the common value in wrong final result!", (boolean)this.testIterator.notCommon().contains(commonValue));
        Assert.assertTrue((String)"Didn't find the not-common value in correct final result!", (boolean)this.testIterator.notCommon().contains(onlyInCollection));
        Assert.assertFalse((String)"Found the not-common value in wrong final result!", (boolean)this.testIterator.common().contains(onlyInCollection));
    }

    @Test
    public void testDifferencingWithMoreCommonValues() {
        UnmodifiableIterator i = Iterators.forArray((Object[])new String[]{onlyInIteratorValue, commonValue, commonValue, commonValue2});
        this.testIterator = new DifferencingIterator(this.toBeCompared2, (Iterator)i);
        Assert.assertTrue((String)"Didn't see a first value!", (boolean)this.testIterator.hasNext());
        Assert.assertEquals((String)"Retrieved final results too early!", null, (Object)this.testIterator.notCommon());
        Assert.assertEquals((String)"Retrieved final results too early!", null, (Object)this.testIterator.common());
        Assert.assertEquals((String)"Didn't get the only-in-iterator value!", (Object)onlyInIteratorValue, (Object)this.testIterator.next());
        Assert.assertFalse((String)"Shouldn't see any more values!", (boolean)this.testIterator.hasNext());
        Assert.assertTrue((String)"Didn't find the common value in correct final result!", (boolean)this.testIterator.common().contains(commonValue));
        Assert.assertTrue((String)"Didn't find the second common value in correct final result!", (boolean)this.testIterator.common().contains(commonValue2));
        Assert.assertFalse((String)"Found the common value in wrong final result!", (boolean)this.testIterator.notCommon().contains(commonValue));
        Assert.assertFalse((String)"Found the second common value in wrong final result!", (boolean)this.testIterator.notCommon().contains(commonValue2));
        Assert.assertTrue((String)"Didn't find the not-common value in correct final result!", (boolean)this.testIterator.notCommon().contains(onlyInCollection));
        Assert.assertFalse((String)"Found the not-common value in wrong final result!", (boolean)this.testIterator.common().contains(onlyInCollection));
    }

    @Test
    public void testDifferencingWithNoValues() {
        UnmodifiableIterator i = Iterators.forArray((Object[])new String[0]);
        this.testIterator = new DifferencingIterator(this.toBeCompared, (Iterator)i);
        Assert.assertFalse((String)"Found a value where there should be none!", (boolean)this.testIterator.hasNext());
    }
}

