/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.observer;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Throwables;
import com.google.common.eventbus.EventBus;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.fcrepo.metrics.RegistryService;
import org.modeshape.jcr.api.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRemovalEventObserver
implements EventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeRemovalEventObserver.class);
    static final Counter EVENT_COUNTER = RegistryService.getMetrics().counter(MetricRegistry.name(NodeRemovalEventObserver.class, (String[])new String[]{"onEvent"}));
    static final int EVENT_TYPES = 2;
    @Inject
    private Repository repository;
    @Inject
    private EventBus eventBus;
    private Session session;

    @PostConstruct
    public void buildListener() throws RepositoryException {
        this.session = this.repository.login();
        this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 2, null, true, null, null, false);
        this.session.save();
    }

    @PreDestroy
    public void stopListening() throws RepositoryException {
        this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        this.session.logout();
    }

    public void onEvent(EventIterator events) {
        while (events.hasNext()) {
            Event e = events.nextEvent();
            try {
                int ls;
                String ePath = e.getPath();
                if (ePath.startsWith("jcr:", (ls = ePath.lastIndexOf(47)) + 1)) continue;
                LOGGER.debug("Putting event: {} on the bus", (Object)e);
                EVENT_COUNTER.inc();
                this.eventBus.post((Object)e);
            }
            catch (RepositoryException ex) {
                throw Throwables.propagate((Throwable)ex);
            }
        }
    }
}

