/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl;

import com.google.common.base.Preconditions;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGraphSubjects
implements GraphSubjects {
    public static final String RESOURCE_NAMESPACE = "info:fedora/";
    private final Resource context;
    private final Session session;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGraphSubjects.class);

    public DefaultGraphSubjects(Session session) {
        this.session = session;
        this.context = ResourceFactory.createResource();
    }

    @Override
    public Resource getGraphSubject(String absPath) throws RepositoryException {
        if (absPath.endsWith("jcr:content")) {
            return ResourceFactory.createResource((String)(RESOURCE_NAMESPACE + absPath.replace("jcr:content", "fcr:content").substring(1)));
        }
        return ResourceFactory.createResource((String)(RESOURCE_NAMESPACE + absPath.substring(1)));
    }

    @Override
    public Resource getContext() {
        return this.context;
    }

    @Override
    public Resource getGraphSubject(Node node) throws RepositoryException {
        LOGGER.trace("Returning RDF subject for: {}", (Object)node);
        return this.getGraphSubject(node.getPath());
    }

    @Override
    public Node getNodeFromGraphSubject(Resource subject) throws RepositoryException {
        String absPath = this.getPathFromGraphSubject(subject);
        if (absPath == null) {
            return null;
        }
        if (this.session.nodeExists(absPath)) {
            return this.session.getNode(absPath);
        }
        return null;
    }

    @Override
    public String getPathFromGraphSubject(Resource subject) throws RepositoryException {
        if (!this.isFedoraGraphSubject(subject)) {
            return null;
        }
        String absPath = subject.getURI().substring(RESOURCE_NAMESPACE.length() - 1);
        if (absPath.endsWith("fcr:content")) {
            return absPath.replace("fcr:content", "jcr:content");
        }
        return absPath;
    }

    @Override
    public boolean isFedoraGraphSubject(Resource subject) {
        Preconditions.checkNotNull((Object)subject, (Object)"null cannot be a Fedora object!");
        return subject.isURIResource() && subject.getURI().startsWith(RESOURCE_NAMESPACE);
    }
}

